/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.worldgen.structures;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.thevortex.allthemodium.worldgen.structures.APStructure;
import com.thevortex.allthemodium.worldgen.structures.DungeonStructure;
import com.thevortex.allthemodium.worldgen.structures.PVStructure;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ATMStructures {
    public static final DeferredRegister<StructureFeature<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"allthemodium");
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> DUNGEON = STRUCTURES.register("dungeon", () -> new DungeonStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> PYRAMID = STRUCTURES.register("ancient_pyramid", () -> new APStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> VILLAGE = STRUCTURES.register("piglin_village", () -> new PVStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));

    public static void setupStructures() {
        ATMStructures.setupMapSpacingAndLand((StructureFeature)DUNGEON.get(), new StructureFeatureConfiguration(130, 100, 902961297), true);
        ATMStructures.setupMapSpacingAndLand((StructureFeature)PYRAMID.get(), new StructureFeatureConfiguration(80, 70, 867530999), true);
        ATMStructures.setupMapSpacingAndLand((StructureFeature)VILLAGE.get(), new StructureFeatureConfiguration(25, 10, 314152976), true);
    }

    public static <F extends StructureFeature<?>> void setupMapSpacingAndLand(F structure, StructureFeatureConfiguration StructureFeatureConfiguration2, boolean transformSurroundingLand) {
        StructureFeature.f_67012_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            StructureFeature.f_67031_ = ImmutableList.builder().addAll((Iterable)StructureFeature.f_67031_).add(structure).build();
        }
        StructureSettings.f_64580_ = ImmutableMap.builder().putAll((Map)StructureSettings.f_64580_).put(structure, (Object)StructureFeatureConfiguration2).build();
        BuiltinRegistries.f_123866_.m_6579_().forEach(settings -> {
            Map structureMap = ((NoiseGeneratorSettings)settings.getValue()).m_64457_().m_64590_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(structureMap);
                tempMap.put(structure, StructureFeatureConfiguration2);
                ((NoiseGeneratorSettings)settings.getValue()).m_64457_().f_64582_ = tempMap;
            } else {
                structureMap.put(structure, StructureFeatureConfiguration2);
            }
        });
    }
}

