/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass.data;

import com.supermartijn642.connectedglass.CGGlassType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;

public class CGTagProvider {
    public static final Map<Tag.Named<Block>, List<Block>> BLOCK_TAGS = new HashMap<Tag.Named<Block>, List<Block>>();
    public static final Map<Tag.Named<Item>, List<Block>> ITEM_TAGS = new HashMap<Tag.Named<Item>, List<Block>>();

    public static void init() {
        ArrayList<Block> glass = new ArrayList<Block>();
        ArrayList<Block> glassColored = new ArrayList<Block>();
        ArrayList<Block> glassColorless = new ArrayList<Block>();
        ArrayList<Block> glassTinted = new ArrayList<Block>();
        ArrayList<Block> panes = new ArrayList<Block>();
        ArrayList<Block> panesColored = new ArrayList<Block>();
        ArrayList<Block> panesColorless = new ArrayList<Block>();
        ArrayList<Block> panesTinted = new ArrayList<Block>();
        for (CGGlassType type : CGGlassType.values()) {
            glass.addAll(type.blocks);
            if (type.isTinted) {
                glassTinted.addAll(type.blocks);
            } else {
                glassColored.addAll(type.colored_blocks.values());
                glassColorless.add((Block)type.block);
            }
            if (!type.hasPanes) continue;
            panes.addAll(type.panes);
            if (type.isTinted) {
                panesTinted.addAll(type.panes);
                continue;
            }
            panesColored.addAll(type.colored_panes.values());
            panesColorless.add((Block)type.pane);
        }
        CGTagProvider.add(glass, (Tag.Named<Block>)Tags.Blocks.GLASS, (Tag.Named<Item>)Tags.Items.GLASS);
        CGTagProvider.add(glassColored, (Tag.Named<Block>)Tags.Blocks.STAINED_GLASS, (Tag.Named<Item>)Tags.Items.STAINED_GLASS);
        CGTagProvider.add(glassColorless, (Tag.Named<Block>)Tags.Blocks.GLASS_COLORLESS, (Tag.Named<Item>)Tags.Items.GLASS_COLORLESS);
        CGTagProvider.add(glassTinted, (Tag.Named<Block>)BlockTags.createOptional((ResourceLocation)new ResourceLocation("forge", "glass/tinted")), (Tag.Named<Item>)ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", "glass/tinted")));
        CGTagProvider.add(panes, (Tag.Named<Block>)Tags.Blocks.GLASS_PANES, (Tag.Named<Item>)Tags.Items.GLASS_PANES);
        CGTagProvider.add(panesColored, (Tag.Named<Block>)Tags.Blocks.STAINED_GLASS_PANES, (Tag.Named<Item>)Tags.Items.STAINED_GLASS_PANES);
        CGTagProvider.add(panesColorless, (Tag.Named<Block>)Tags.Blocks.GLASS_PANES_COLORLESS, (Tag.Named<Item>)Tags.Items.GLASS_PANES_COLORLESS);
        CGTagProvider.add(panesTinted, (Tag.Named<Block>)BlockTags.createOptional((ResourceLocation)new ResourceLocation("forge", "glass_panes/tinted")), (Tag.Named<Item>)ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", "glass_panes/tinted")));
    }

    private static void add(List<Block> blocks, Tag.Named<Block> blockTag, Tag.Named<Item> itemTag) {
        BLOCK_TAGS.put(blockTag, blocks);
        ITEM_TAGS.put(itemTag, blocks);
    }
}

