/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture;

import com.blakebr0.cucumber.helper.ConfigHelper;
import com.blakebr0.mysticalagriculture.MACreativeTab;
import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.client.ModelHandler;
import com.blakebr0.mysticalagriculture.compat.TOPCompat;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.crafting.DynamicRecipeManager;
import com.blakebr0.mysticalagriculture.data.ModDataGenerators;
import com.blakebr0.mysticalagriculture.handler.AugmentHandler;
import com.blakebr0.mysticalagriculture.handler.ColorHandler;
import com.blakebr0.mysticalagriculture.handler.ExperienceCapsuleHandler;
import com.blakebr0.mysticalagriculture.handler.MobDropHandler;
import com.blakebr0.mysticalagriculture.handler.MobSoulHandler;
import com.blakebr0.mysticalagriculture.init.ModBlocks;
import com.blakebr0.mysticalagriculture.init.ModContainerTypes;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.item.FertilizedEssenceItem;
import com.blakebr0.mysticalagriculture.item.MysticalFertilizerItem;
import com.blakebr0.mysticalagriculture.lib.ModItemTier;
import com.blakebr0.mysticalagriculture.network.NetworkHandler;
import com.blakebr0.mysticalagriculture.registry.AugmentRegistry;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import com.blakebr0.mysticalagriculture.registry.MobSoulTypeRegistry;
import com.blakebr0.mysticalagriculture.registry.PluginRegistry;
import com.blakebr0.mysticalagriculture.world.ModWorldFeatures;
import com.blakebr0.mysticalagriculture.world.ModWorldgenRegistration;
import java.lang.reflect.Field;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mysticalagriculture")
public final class MysticalAgriculture {
    public static final String MOD_ID = "mysticalagriculture";
    public static final String NAME = "Mystical Agriculture";
    public static final CreativeModeTab CREATIVE_TAB = new MACreativeTab();
    public static final Logger LOGGER = LogManager.getLogger((String)"Mystical Agriculture");

    public MysticalAgriculture() throws NoSuchFieldException, IllegalAccessException {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.register((Object)this);
        bus.register((Object)new ModBlocks());
        bus.register((Object)new ModItems());
        bus.register((Object)new ModRecipeSerializers());
        bus.register((Object)new ModContainerTypes());
        bus.register((Object)new ModDataGenerators());
        ModTileEntities.REGISTRY.register(bus);
        ModWorldFeatures.REGISTRY.register(bus);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            bus.register((Object)new ColorHandler());
            bus.register((Object)new ModelHandler());
        });
        MinecraftForge.EVENT_BUS.register((Object)new ModWorldgenRegistration());
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ModConfigs.CLIENT);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfigs.COMMON);
        MysticalAgriculture.initAPI();
        PluginRegistry.getInstance().loadPlugins();
        ConfigHelper.load((ForgeConfigSpec)ModConfigs.COMMON, (String)"mysticalagriculture-common.toml");
    }

    @SubscribeEvent
    public void onCommonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new DynamicRecipeManager());
        MinecraftForge.EVENT_BUS.register((Object)new MobDropHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MobSoulHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ExperienceCapsuleHandler());
        MinecraftForge.EVENT_BUS.register((Object)new AugmentHandler());
        ModRecipeSerializers.onCommonSetup();
        ModItemTier.onCommonSetup();
        event.enqueueWork(() -> {
            ModWorldgenRegistration.onCommonSetup();
            NetworkHandler.onCommonSetup();
            FertilizedEssenceItem.DispenserBehavior.register();
            MysticalFertilizerItem.DispenserBehavior.register();
        });
    }

    @SubscribeEvent
    public void onClientSetup(FMLClientSetupEvent event) {
        ModelHandler.onClientSetup(event);
        ModTileEntities.onClientSetup();
        ModContainerTypes.onClientSetup();
    }

    @SubscribeEvent
    public void onInterModEnqueue(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            TOPCompat.onInterModEnqueue();
        }
    }

    private static void initAPI() throws NoSuchFieldException, IllegalAccessException {
        Class<MysticalAgricultureAPI> api = MysticalAgricultureAPI.class;
        Field cropRegistry = api.getDeclaredField("cropRegistry");
        Field augmentRegistry = api.getDeclaredField("augmentRegistry");
        Field soulTypeRegistry = api.getDeclaredField("soulTypeRegistry");
        cropRegistry.setAccessible(true);
        cropRegistry.set(null, CropRegistry.getInstance());
        augmentRegistry.setAccessible(true);
        augmentRegistry.set(null, AugmentRegistry.getInstance());
        soulTypeRegistry.setAccessible(true);
        soulTypeRegistry.set(null, MobSoulTypeRegistry.getInstance());
    }
}

