/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.crafting.recipe.InfusionRecipe;
import com.blakebr0.mysticalagriculture.crafting.recipe.ReprocessorRecipe;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DynamicRecipeManager
implements ResourceManagerReloadListener {
    public void m_6213_(ResourceManager resourceManager) {
        CropRegistry.getInstance().getCrops().forEach(crop -> {
            ISpecialRecipe seed = this.makeSeedRecipe((Crop)crop);
            Recipe<?> seedRegular = this.makeRegularSeedRecipe((Crop)crop);
            ISpecialRecipe reprocessor = this.makeReprocessorRecipe((Crop)crop);
            if (seed != null) {
                RecipeHelper.addRecipe((Recipe)seed);
            }
            if (seedRegular != null) {
                RecipeHelper.addRecipe(seedRegular);
            }
            if (reprocessor != null) {
                RecipeHelper.addRecipe((Recipe)reprocessor);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)this);
    }

    private ISpecialRecipe makeSeedRecipe(Crop crop) {
        if (!crop.isEnabled() || !crop.getRecipeConfig().isSeedInfusionRecipeEnabled()) {
            return null;
        }
        Item essenceItem = crop.getTier().getEssence();
        if (essenceItem == null) {
            return null;
        }
        Item craftingSeedItem = crop.getType().getCraftingSeed();
        if (craftingSeedItem == null) {
            return null;
        }
        Ingredient material = crop.getCraftingMaterial();
        if (material == Ingredient.f_43901_) {
            return null;
        }
        Ingredient essence = Ingredient.m_43929_((ItemLike[])new ItemLike[]{essenceItem});
        Ingredient craftingSeed = Ingredient.m_43929_((ItemLike[])new ItemLike[]{craftingSeedItem});
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{craftingSeed, material, essence, material, essence, material, essence, material, essence});
        ResourceLocation name = new ResourceLocation("mysticalagriculture", crop.getNameWithSuffix("seeds_infusion"));
        ItemStack output = new ItemStack((ItemLike)crop.getSeedsItem());
        return new InfusionRecipe(name, (NonNullList<Ingredient>)inputs, output);
    }

    private Recipe<?> makeRegularSeedRecipe(Crop crop) {
        if (!crop.isEnabled() || !crop.getRecipeConfig().isSeedCraftingRecipeEnabled()) {
            return null;
        }
        if (!((Boolean)ModConfigs.SEED_CRAFTING_RECIPES.get()).booleanValue()) {
            return null;
        }
        Item essenceItem = crop.getTier().getEssence();
        if (essenceItem == null) {
            return null;
        }
        Item craftingSeedItem = crop.getType().getCraftingSeed();
        if (craftingSeedItem == null) {
            return null;
        }
        Ingredient material = crop.getCraftingMaterial();
        if (material == Ingredient.f_43901_) {
            return null;
        }
        Ingredient essence = Ingredient.m_43929_((ItemLike[])new ItemLike[]{essenceItem});
        Ingredient craftingSeed = Ingredient.m_43929_((ItemLike[])new ItemLike[]{craftingSeedItem});
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{material, essence, material, essence, craftingSeed, essence, material, essence, material});
        ResourceLocation name = new ResourceLocation("mysticalagriculture", crop.getNameWithSuffix("seeds_vanilla"));
        ItemStack output = new ItemStack((ItemLike)crop.getSeedsItem());
        return new ShapedRecipe(name, "", 3, 3, inputs, output);
    }

    private ISpecialRecipe makeReprocessorRecipe(Crop crop) {
        if (!crop.isEnabled() || !crop.getRecipeConfig().isSeedReprocessorRecipeEnabled()) {
            return null;
        }
        Ingredient input = Ingredient.m_43929_((ItemLike[])new ItemLike[]{crop.getSeedsItem()});
        ResourceLocation name = new ResourceLocation("mysticalagriculture", crop.getNameWithSuffix("seeds_reprocessor"));
        ItemStack output = new ItemStack((ItemLike)crop.getEssenceItem(), 2);
        return new ReprocessorRecipe(name, input, output);
    }
}

