/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.recipe;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.mysticalagriculture.api.crafting.IReprocessorRecipe;
import com.blakebr0.mysticalagriculture.api.crafting.RecipeTypes;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ReprocessorRecipe
implements ISpecialRecipe,
IReprocessorRecipe {
    private final ResourceLocation recipeId;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;

    public ReprocessorRecipe(ResourceLocation recipeId, Ingredient input, ItemStack output) {
        this.recipeId = recipeId;
        this.inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{input});
        this.output = output;
    }

    public ItemStack assemble(IItemHandler inventory) {
        return this.output.m_41777_();
    }

    public ItemStack m_5874_(Container inv) {
        return this.assemble((IItemHandler)new InvWrapper(inv));
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<ReprocessorRecipe> m_7707_() {
        return ModRecipeSerializers.REPROCESSOR;
    }

    public RecipeType<? extends IReprocessorRecipe> m_6671_() {
        return RecipeTypes.REPROCESSOR;
    }

    public boolean matches(IItemHandler inventory) {
        ItemStack stack = inventory.getStackInSlot(0);
        return ((Ingredient)this.inputs.get(0)).test(stack);
    }

    public boolean m_5818_(Container inv, Level level) {
        return this.matches((IItemHandler)new InvWrapper(inv));
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ReprocessorRecipe> {
        public ReprocessorRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonObject ingredient = json.getAsJsonObject("input");
            Ingredient input = Ingredient.m_43917_((JsonElement)ingredient);
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)json.getAsJsonObject("result"));
            return new ReprocessorRecipe(recipeId, input, output);
        }

        public ReprocessorRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            return new ReprocessorRecipe(recipeId, input, output);
        }

        public void toNetwork(FriendlyByteBuf buffer, ReprocessorRecipe recipe) {
            ((Ingredient)recipe.inputs.get(0)).m_43923_(buffer);
            buffer.m_130055_(recipe.output);
        }
    }
}

