/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.logic.entityblocking.megatorch;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.TorchmasterConfig;
import net.xalcon.torchmaster.common.ModBlocks;
import net.xalcon.torchmaster.common.logic.DistanceLogics;
import net.xalcon.torchmaster.common.logic.entityblocking.IEntityBlockingLight;

public class MegatorchEntityBlockingLight
implements IEntityBlockingLight {
    public static final VoxelShape SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private BlockPos pos;

    public MegatorchEntityBlockingLight(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public boolean shouldBlockEntity(Entity entity, BlockPos pos) {
        return Torchmaster.MegaTorchFilterRegistry.containsEntity(entity.m_6095_().getRegistryName()) && DistanceLogics.Cubic.isPositionInRange(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), this.pos, (Integer)TorchmasterConfig.GENERAL.megaTorchRadius.get());
    }

    @Override
    public String getLightSerializerKey() {
        return "megatorch";
    }

    @Override
    public boolean cleanupCheck(Level level) {
        return level.m_46749_(this.pos) && level.m_8055_(this.pos).m_60734_() != ModBlocks.blockMegaTorch;
    }

    @Override
    public String getName() {
        return "Mega Torch";
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }
}

