/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.registry;

import com.google.common.collect.ImmutableList;
import com.legacy.structure_gel.core.SGAccessors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryHelper {
    public static <T extends IForgeRegistryEntry<T>, C extends T> C register(IForgeRegistry<T> registry, ResourceLocation key, C registryObject) {
        registryObject.setRegistryName(key);
        registry.register(registryObject);
        return registryObject;
    }

    public static PoiType registerPOI(IForgeRegistry<PoiType> registry, PoiType poi) {
        SGAccessors.invokeStatic(SGAccessors.POI_REGISTER_BLOCK_STATES, poi);
        return RegistryHelper.register(registry, new ResourceLocation(poi.toString()), poi);
    }

    public static StructureProcessorList registerProcessor(ResourceLocation key, StructureProcessor processor) {
        return RegistryHelper.registerProcessor(key, (List<StructureProcessor>)ImmutableList.of((Object)processor));
    }

    public static StructureProcessorList registerProcessor(ResourceLocation key, List<StructureProcessor> processors) {
        return RegistryHelper.registerProcessor(key, new StructureProcessorList(processors));
    }

    public static StructureProcessorList registerProcessor(ResourceLocation key, StructureProcessorList processorList) {
        return (StructureProcessorList)BuiltinRegistries.m_123880_((Registry)BuiltinRegistries.f_123863_, (ResourceLocation)key, (Object)processorList);
    }

    public static StructureProcessorList combineProcessors(StructureProcessorList ... structureProcessors) {
        ArrayList processors = new ArrayList();
        for (StructureProcessorList spl : structureProcessors) {
            processors.addAll(spl.m_74425_());
        }
        return new StructureProcessorList(processors);
    }

    public static StructureProcessorList combineProcessors(StructureProcessorList structureProcessorList, StructureProcessor ... structureProcessors) {
        ArrayList<StructureProcessor> processors = new ArrayList<StructureProcessor>(structureProcessorList.m_74425_());
        processors.addAll(Arrays.asList(structureProcessors));
        return new StructureProcessorList(processors);
    }
}

