/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure;

import com.legacy.structure_gel.api.config.StructureConfig;
import com.legacy.structure_gel.api.structure.GelStructure;
import com.legacy.structure_gel.api.structure.base.IConfigStructure;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public abstract class GelConfigStructure<C extends FeatureConfiguration>
extends GelStructure<C>
implements IConfigStructure {
    private final StructureConfig config;

    public GelConfigStructure(Codec<C> codec, StructureConfig config, PieceGenerator<C> generator) {
        super(codec, generator);
        this.config = config;
    }

    public GelConfigStructure(Codec<C> codec, StructureConfig config, PieceGeneratorSupplier<C> pieceGeneratorSupplier) {
        super(codec, pieceGeneratorSupplier);
        this.config = config;
    }

    public GelConfigStructure(Codec<C> codec, StructureConfig config, PieceGeneratorSupplier<C> pieceGeneratorSupplier, PostPlacementProcessor postPlacementProcessor) {
        super(codec, pieceGeneratorSupplier, postPlacementProcessor);
        this.config = config;
    }

    @Override
    public StructureConfig getConfig() {
        return this.config;
    }

    @Override
    public float getProbability() {
        return this.getConfig().getProbability();
    }

    @Override
    public int getSpacing() {
        return this.getConfig().getSpacing();
    }

    @Override
    public int getOffset() {
        return this.getConfig().getOffset();
    }

    @Override
    @Nullable
    public Set<ResourceLocation> getValidDimensions() {
        return this.getConfig().getValidDimensions();
    }

    @Override
    @Nullable
    public List<MobSpawnSettings.SpawnerData> getDefaultSpawnList(MobCategory category) {
        return this.getConfig().getSpawnsForClassification(category);
    }
}

