/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure.jigsaw;

import com.legacy.structure_gel.api.structure.base.IModifyState;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawAccessHelper;
import com.legacy.structure_gel.core.structure.jigsaw.GelSinglePoolElement;
import com.legacy.structure_gel.core.util.Internal;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.feature.structures.SinglePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Material;

public abstract class AbstractGelStructurePiece
extends PoolElementStructurePiece
implements IModifyState {
    public AbstractGelStructurePiece(StructureManager structureManager, StructurePoolElement poolElement, BlockPos pos, int groundLevelDelta, Rotation rotation, BoundingBox bounds) {
        super(structureManager, poolElement, pos, groundLevelDelta, rotation, bounds);
        this.setStructurePieceType(this.m_73550_());
    }

    public AbstractGelStructurePiece(StructurePieceSerializationContext context, CompoundTag nbt) {
        super(context, nbt);
        this.setStructurePieceType(this.m_73550_());
    }

    public abstract void handleDataMarker(String var1, BlockPos var2, ServerLevelAccessor var3, Random var4, BoundingBox var5);

    public abstract StructurePieceType m_73550_();

    private void setStructurePieceType(StructurePieceType structurePieceType) {
        this.f_73380_ = structurePieceType;
    }

    @Internal
    public void m_192416_(WorldGenLevel level, StructureFeatureManager structureManager, ChunkGenerator chunkGen, Random rand, BoundingBox bounds, BlockPos pos, boolean isLegacy) {
        StructurePoolElement structurePoolElement = this.f_72597_;
        if (structurePoolElement instanceof GelSinglePoolElement) {
            GelSinglePoolElement gelElement = (GelSinglePoolElement)structurePoolElement;
            gelElement.place(this.f_72603_, level, structureManager, chunkGen, this.f_72598_, pos, this.f_72599_, bounds, rand, isLegacy, this);
        } else {
            this.f_72597_.m_6791_(this.f_72603_, level, structureManager, chunkGen, this.f_72598_, pos, this.f_72599_, bounds, rand, isLegacy);
        }
    }

    @Override
    @Nullable
    public BlockState modifyState(ServerLevelAccessor level, Random rand, BlockPos pos, BlockState originalState) {
        return originalState;
    }

    public <T extends Entity> T createEntity(EntityType<T> entityType, ServerLevelAccessor level, BlockPos pos, Rotation rotation) {
        Entity entity = entityType.m_20615_((Level)level.m_6018_());
        entity.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, rotation.m_55954_(Direction.SOUTH).m_122435_(), 0.0f);
        return (T)entity;
    }

    public ResourceLocation getLocation() {
        StructurePoolElement structurePoolElement = this.f_72597_;
        if (structurePoolElement instanceof SinglePoolElement) {
            SinglePoolElement singleElement = (SinglePoolElement)structurePoolElement;
            return JigsawAccessHelper.getSingleJigsawPieceLocation(singleElement);
        }
        return new ResourceLocation("empty");
    }

    public StructureManager getStructureManager() {
        return this.f_72603_;
    }

    public Vec3i getSize() {
        Optional optional = this.getStructureManager().m_163774_(this.getLocation());
        return optional.isPresent() ? ((StructureTemplate)optional.get()).m_163801_() : Vec3i.f_123288_;
    }

    public void setAir(LevelAccessor level, BlockPos pos) {
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
    }

    public void extendDown(LevelAccessor level, BlockState state, BoundingBox bounds, Rotation rotation, Random rand) {
        this.extendDown(level, (Random random) -> state, bounds, rotation, rand);
    }

    public void extendDown(LevelAccessor level, Function<Random, BlockState> randStateGetter, BoundingBox bounds, Rotation rotation, Random rand) {
        int offsetX = rotation == Rotation.CLOCKWISE_180 || this.f_72599_ == Rotation.CLOCKWISE_90 ? -(this.getSize().m_123341_() - 1) : 0;
        int offsetZ = rotation == Rotation.CLOCKWISE_180 || this.f_72599_ == Rotation.COUNTERCLOCKWISE_90 ? -(this.getSize().m_123343_() - 1) : 0;
        for (int x = 0; x < 13; ++x) {
            for (int z = 0; z < 13; ++z) {
                if (level.m_8055_(this.f_72598_.m_142082_(x + offsetX, 0, z + offsetZ)).m_60767_() == Material.f_76296_) continue;
                int offsetY = -1;
                while ((level.m_46859_(this.f_72598_.m_142082_(x + offsetX, offsetY, z + offsetZ)) || level.m_8055_(this.f_72598_.m_142082_(x + offsetX, offsetY, z + offsetZ)).m_60767_().m_76332_()) && this.f_72598_.m_123342_() + offsetY > 0) {
                    level.m_7731_(this.f_72598_.m_142082_(x + offsetX, offsetY, z + offsetZ), randStateGetter.apply(rand), 2);
                    --offsetY;
                }
            }
        }
    }
}

