/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure.jigsaw;

import com.legacy.structure_gel.core.StructureGelMod;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.structures.FeaturePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.ListPoolElement;
import net.minecraft.world.level.levelgen.feature.structures.SinglePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructurePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class JigsawAccessHelper {
    public static void addToPool(ResourceLocation pool, List<Pair<StructurePoolElement, Integer>> pieces) {
        JigsawAccessHelper.modifyJigsawPattern(pool, template -> {
            for (Pair pair : pieces) {
                for (int i = 0; i < (Integer)pair.getSecond(); ++i) {
                    template.f_69250_.add((StructurePoolElement)pair.getFirst());
                }
            }
        });
    }

    public static void modifyJigsawPattern(ResourceLocation key, Consumer<StructureTemplatePool> action) {
        BuiltinRegistries.f_123864_.m_6612_(key).ifPresentOrElse(action, () -> StructureGelMod.logError("Could not perform an action on {} because it has not been created yet.", key));
    }

    public static ResourceLocation getSingleJigsawPieceLocation(SinglePoolElement element) {
        return (ResourceLocation)element.f_69098_.left().get();
    }

    public static List<StructurePoolElement> getListJigsawPiecePieces(ListPoolElement element) {
        return element.f_69058_;
    }

    public static PlacedFeature getFeatureJigsawPieceFeatures(FeaturePoolElement element) {
        return (PlacedFeature)element.f_68883_.get();
    }

    @Deprecated(forRemoval=true, since="1.18.1-v2.1.0")
    public static void clearPool(ResourceLocation pool) {
        JigsawAccessHelper.modifyJigsawPattern(pool, template -> template.f_69250_.clear());
    }

    @Deprecated(forRemoval=true, since="1.18.1-v2.1.0")
    public static void removeFromPool(ResourceLocation pool, ResourceLocation elementName) {
        JigsawAccessHelper.modifyJigsawPattern(pool, template -> template.f_69250_.removeIf(element -> {
            if (element instanceof SinglePoolElement) {
                SinglePoolElement singleElement = (SinglePoolElement)element;
                return JigsawAccessHelper.getSingleJigsawPieceLocation(singleElement).equals((Object)elementName);
            }
            if (element instanceof ListPoolElement) {
                ListPoolElement listElement = (ListPoolElement)element;
                return JigsawAccessHelper.removeFromListJigsaw(listElement, elementName);
            }
            return false;
        }));
    }

    @Deprecated(forRemoval=true, since="1.18.1-v2.1.0")
    public static void removeFromPool(ResourceLocation pool, Feature<?> feature) {
        JigsawAccessHelper.modifyJigsawPattern(pool, template -> template.f_69250_.removeIf(element -> {
            if (element instanceof FeaturePoolElement) {
                FeaturePoolElement featureElement = (FeaturePoolElement)element;
                return JigsawAccessHelper.getFeatureJigsawPieceFeatures(featureElement).m_191781_().anyMatch(cf -> cf.f_65377_ == feature);
            }
            if (element instanceof ListPoolElement) {
                ListPoolElement listElement = (ListPoolElement)element;
                return JigsawAccessHelper.removeFromListJigsaw(listElement, feature);
            }
            return false;
        }));
    }

    @Deprecated(forRemoval=true, since="1.18.1-v2.1.0")
    public static boolean removeFromListJigsaw(ListPoolElement listElement, ResourceLocation elementName) {
        JigsawAccessHelper.getListJigsawPiecePieces(listElement).removeIf(element -> {
            if (element instanceof SinglePoolElement) {
                SinglePoolElement singleElement = (SinglePoolElement)element;
                return JigsawAccessHelper.getSingleJigsawPieceLocation(singleElement).equals((Object)elementName);
            }
            if (element instanceof ListPoolElement) {
                ListPoolElement l = (ListPoolElement)element;
                JigsawAccessHelper.removeFromListJigsaw(l, elementName);
                return JigsawAccessHelper.getListJigsawPiecePieces(l).isEmpty();
            }
            return false;
        });
        return JigsawAccessHelper.getListJigsawPiecePieces(listElement).isEmpty();
    }

    @Deprecated(forRemoval=true, since="1.18.1-v2.1.0")
    public static boolean removeFromListJigsaw(ListPoolElement listElement, Feature<?> feature) {
        JigsawAccessHelper.getListJigsawPiecePieces(listElement).removeIf(piece -> {
            if (piece instanceof FeaturePoolElement) {
                FeaturePoolElement featureElement = (FeaturePoolElement)piece;
                return JigsawAccessHelper.getFeatureJigsawPieceFeatures(featureElement).m_191781_().anyMatch(cf -> cf.f_65377_ == feature);
            }
            if (piece instanceof ListPoolElement) {
                ListPoolElement l = (ListPoolElement)piece;
                JigsawAccessHelper.removeFromListJigsaw(l, feature);
                return JigsawAccessHelper.getListJigsawPiecePieces(l).isEmpty();
            }
            return false;
        });
        return JigsawAccessHelper.getListJigsawPiecePieces(listElement).isEmpty();
    }
}

