/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core;

import com.legacy.structure_gel.api.biome_dictionary.BiomeDictionary;
import com.legacy.structure_gel.api.block.AxisStructureGelBlock;
import com.legacy.structure_gel.api.block.StructureGelBlock;
import com.legacy.structure_gel.api.block.base.IStructureGel;
import com.legacy.structure_gel.api.item.StructureGelItem;
import com.legacy.structure_gel.api.registry.RegistryHelper;
import com.legacy.structure_gel.api.structure.processor.RandomBlockSwapProcessor;
import com.legacy.structure_gel.api.structure.processor.RandomStateSwapProcessor;
import com.legacy.structure_gel.api.structure.processor.RandomTagSwapProcessor;
import com.legacy.structure_gel.api.structure.processor.RemoveGelStructureProcessor;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.structure.jigsaw.GelSinglePoolElement;
import com.legacy.structure_gel.core.structure.jigsaw.GelStructurePiece;
import com.legacy.structure_gel.core.util.Internal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.feature.structures.StructurePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.IForgeRegistry;

public class SGRegistry {
    @Internal
    public static void init(IEventBus modBus) {
        modBus.addGenericListener(Biome.class, EventPriority.LOWEST, Biomes::init);
        modBus.addGenericListener(Block.class, EventPriority.HIGHEST, Blocks::init);
        modBus.addGenericListener(Item.class, EventPriority.HIGHEST, Items::init);
        modBus.addGenericListener(StructureFeature.class, EventPriority.HIGHEST, StructureRegistry::init);
    }

    protected static class StructureRegistry {
        protected StructureRegistry() {
        }

        public static void init(RegistryEvent.Register<StructureFeature<?>> event) {
            Processors.init();
            JigsawDeserializers.init();
            StructurePieceTypes.init();
        }
    }

    public static class StructurePieceTypes {
        public static final StructurePieceType GEL_JIGSAW = GelStructurePiece::new;

        private static void init() {
            StructurePieceTypes.register("gel_jigsaw", GEL_JIGSAW);
        }

        private static void register(String key, StructurePieceType pieceType) {
            Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)StructureGelMod.locate(key), (Object)pieceType);
        }
    }

    public static class JigsawDeserializers {
        public static final StructurePoolElementType<GelSinglePoolElement> GEL_SINGLE_POOL_ELEMENT = () -> GelSinglePoolElement.CODEC;

        private static void init() {
            JigsawDeserializers.register("gel_single_pool_element", GEL_SINGLE_POOL_ELEMENT);
        }

        private static <P extends StructurePoolElement> void register(String key, StructurePoolElementType<P> jigsawDeserializer) {
            Registry.m_122965_((Registry)Registry.f_122892_, (ResourceLocation)StructureGelMod.locate(key), jigsawDeserializer);
        }
    }

    public static class Processors {
        public static final StructureProcessorType<RemoveGelStructureProcessor> REMOVE_FILLER = () -> RemoveGelStructureProcessor.CODEC;
        public static final StructureProcessorType<RandomBlockSwapProcessor> REPLACE_BLOCK = () -> RandomBlockSwapProcessor.CODEC;
        public static final StructureProcessorType<RandomTagSwapProcessor> REPLACE_TAG = () -> RandomTagSwapProcessor.CODEC;
        public static final StructureProcessorType<RandomStateSwapProcessor> REPLACE_STATE = () -> RandomStateSwapProcessor.CODEC;

        private static void init() {
            Processors.register("remove_filler", REMOVE_FILLER);
            Processors.register("replace_block", REPLACE_BLOCK);
            Processors.register("replace_tag", REPLACE_TAG);
            Processors.register("replace_state", REPLACE_STATE);
        }

        private static <P extends StructureProcessor> void register(String key, StructureProcessorType<P> processorType) {
            Registry.m_122965_((Registry)Registry.f_122891_, (ResourceLocation)StructureGelMod.locate(key), processorType);
        }
    }

    public static class Items {
        protected static void init(RegistryEvent.Register<Item> event) {
            Blocks.BLOCKS.forEach(b -> RegistryHelper.register(event.getRegistry(), b.getRegistryName(), new StructureGelItem((StructureGelBlock)b)));
        }
    }

    public static class Blocks {
        public static final List<Block> BLOCKS = new ArrayList<Block>();
        public static final StructureGelBlock RED_GEL = new StructureGelBlock(new IStructureGel.IBehavior[0]);
        public static final StructureGelBlock BLUE_GEL = new StructureGelBlock(IStructureGel.Behavior.PHOTOSENSITIVE);
        public static final StructureGelBlock GREEN_GEL = new StructureGelBlock(IStructureGel.Behavior.DIAGONAL_SPREAD);
        public static final StructureGelBlock CYAN_GEL = new StructureGelBlock(IStructureGel.Behavior.PHOTOSENSITIVE, IStructureGel.Behavior.DIAGONAL_SPREAD);
        public static final StructureGelBlock ORANGE_GEL = new StructureGelBlock(IStructureGel.Behavior.DYNAMIC_SPREAD_DIST);
        public static final StructureGelBlock YELLOW_GEL = new AxisStructureGelBlock(IStructureGel.Behavior.AXIS_SPREAD);

        protected static void init(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            Blocks.register((IForgeRegistry<Block>)registry, "red_gel", RED_GEL);
            Blocks.register((IForgeRegistry<Block>)registry, "blue_gel", BLUE_GEL);
            Blocks.register((IForgeRegistry<Block>)registry, "green_gel", GREEN_GEL);
            Blocks.register((IForgeRegistry<Block>)registry, "cyan_gel", CYAN_GEL);
            Blocks.register((IForgeRegistry<Block>)registry, "orange_gel", ORANGE_GEL);
            Blocks.register((IForgeRegistry<Block>)registry, "yellow_gel", YELLOW_GEL);
        }

        private static <T extends Block> void register(IForgeRegistry<Block> registry, String key, T object) {
            BLOCKS.add(object);
            RegistryHelper.register(registry, StructureGelMod.locate(key), object);
        }
    }

    protected static class Biomes {
        protected Biomes() {
        }

        protected static void init(RegistryEvent.Register<Biome> registry) {
            BiomeDictionary.init();
        }
    }
}

