/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core;

import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.SGRegistry;
import com.legacy.structure_gel.core.events.SGClientEvents;
import com.legacy.structure_gel.core.events.SGCommonEvents;
import com.legacy.structure_gel.core.util.Internal;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="structure_gel")
@Internal
public class StructureGelMod {
    public static final String MODID = "structure_gel";
    private static final Logger LOGGER = LogManager.getLogger((String)"ModdingLegacy/structure_gel");

    public StructureGelMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SGConfig.COMMON_SPEC);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        SGCommonEvents.init(modBus, forgeBus);
        SGRegistry.init(modBus);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SGConfig.CLIENT_SPEC);
            SGClientEvents.init(modBus, forgeBus);
        });
    }

    private static void log(Level level, Object message, Object ... params) {
        LOGGER.log(level, "[Structure Gel] " + message.toString(), params);
    }

    public static void log(Object message, Object ... params) {
        StructureGelMod.log(Level.INFO, message, params);
    }

    public static void logError(Object message, Object ... params) {
        StructureGelMod.log(Level.ERROR, message, params);
    }

    public static void logWarn(Object message, Object ... params) {
        StructureGelMod.log(Level.WARN, message, params);
    }

    public static void logFatal(Object message, Object ... params) {
        StructureGelMod.log(Level.FATAL, message, params);
    }

    public static void debug(Object message, Object ... params) {
        if (SGConfig.COMMON.consoleDebug()) {
            StructureGelMod.log(message.toString(), params);
        }
    }

    public static ResourceLocation locate(String key) {
        return new ResourceLocation(MODID, key);
    }
}

