/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.events;

import com.legacy.structure_gel.api.block.GelPortalBlock;
import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.SGRegistry;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.capability.entity.GelEntity;
import com.legacy.structure_gel.core.client.GelJigsawRenderer;
import com.legacy.structure_gel.core.util.Internal;
import java.util.List;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.screens.BackupConfirmScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@OnlyIn(value=Dist.CLIENT)
@Internal
public class SGClientEvents {
    public static void init(IEventBus modBus, IEventBus forgeBus) {
        modBus.addListener(SGClientEvents::clientInit);
        forgeBus.addListener(SGClientEvents::skipExperimentalBackupScreen);
        forgeBus.addListener(SGClientEvents::onPlaySound);
        forgeBus.addListener(SGClientEvents::clientPlayerTick);
    }

    protected static void clientInit(FMLClientSetupEvent event) {
        SGRegistry.Blocks.BLOCKS.forEach(b -> ItemBlockRenderTypes.setRenderLayer((Block)b, (RenderType)RenderType.m_110466_()));
        if (SGConfig.CLIENT.showStructureBlockInfo()) {
            BlockEntityRenderers.m_173590_((BlockEntityType)BlockEntityType.f_58910_, GelJigsawRenderer::new);
        }
    }

    protected static void skipExperimentalBackupScreen(ScreenEvent.DrawScreenEvent.Post event) {
        if (SGConfig.CLIENT.skipExperimentalScreen()) {
            Screen screen = event.getScreen();
            if (screen instanceof BackupConfirmScreen) {
                BackupConfirmScreen gui = (BackupConfirmScreen)screen;
                if (SGClientEvents.doesTitleMatch(gui.m_96636_(), "selectWorld.backupQuestion.experimental") && SGClientEvents.hasButton(gui.f_169369_, 1)) {
                    StructureGelMod.log("Skipped backup request screen for world that uses experimental settings. You can disable this via config.", new Object[0]);
                    ((AbstractButton)gui.f_169369_.get(1)).m_5691_();
                }
            } else {
                ConfirmScreen gui;
                screen = event.getScreen();
                if (screen instanceof ConfirmScreen && SGClientEvents.doesTitleMatch((gui = (ConfirmScreen)screen).m_96636_(), "selectWorld.backupQuestion.experimental") && SGClientEvents.hasButton(gui.f_169369_, 0)) {
                    StructureGelMod.log("Skipped world load warning screen for world that uses experimental settings. You can disable this via config.", new Object[0]);
                    ((AbstractButton)gui.f_169369_.get(0)).m_5691_();
                }
            }
        }
    }

    private static boolean hasButton(List<Widget> buttons, int index) {
        return buttons.size() > index && buttons.get(index) instanceof AbstractButton;
    }

    private static boolean doesTitleMatch(Component title, String compare) {
        return title instanceof TranslatableComponent && ((TranslatableComponent)title).m_131328_().equals(compare);
    }

    protected static void onPlaySound(PlaySoundEvent event) {
        SoundInstance originalSound = event.getOriginalSound();
        if (originalSound != null) {
            ResourceLocation name = originalSound.m_7904_();
            GelPortalBlock portal = GelEntity.getPortalClient();
            if (portal != null && name != null) {
                SoundInstance newSound = null;
                if (name.equals((Object)SoundEvents.f_12287_.m_11660_())) {
                    newSound = portal.getTravelSound();
                } else if (name.equals((Object)SoundEvents.f_12288_.m_11660_())) {
                    newSound = portal.getTriggerSound();
                }
                if (newSound != null) {
                    event.setSound(newSound);
                }
            }
        }
    }

    protected static void clientPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.CLIENT) {
            GelEntity.clientTick();
        }
    }
}

