/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.darkmodeeverywhere;

import com.buuz135.darkmodeeverywhere.DarkModeEverywhere;
import com.buuz135.darkmodeeverywhere.ShaderConfig;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientProxy {
    public static ShaderConfig CONFIG = new ShaderConfig();
    public static HashMap<ResourceLocation, ShaderInstance> REGISTERED_SHADERS = new HashMap();
    public static HashMap<ResourceLocation, ShaderConfig.Value> SHADER_VALUES = new HashMap();
    public static ResourceLocation SELECTED_SHADER = null;

    public ClientProxy() {
        ShaderConfig.load();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::shaderRegister);
        MinecraftForge.EVENT_BUS.addListener(this::openGui);
    }

    @SubscribeEvent
    public void shaderRegister(RegisterShadersEvent event) {
        REGISTERED_SHADERS = new HashMap();
        SHADER_VALUES = new HashMap();
        ArrayList<String> loaderShaders = new ArrayList<String>();
        for (ShaderConfig.Value shader : CONFIG.getShaders()) {
            SHADER_VALUES.put(new ResourceLocation(shader.resourceLocation), shader);
            if (loaderShaders.contains(shader.resourceLocation)) continue;
            try {
                event.registerShader(new ShaderInstance((ResourceProvider)event.getResourceManager(), new ResourceLocation(shader.resourceLocation), DefaultVertexFormat.f_85817_), shaderInstance -> REGISTERED_SHADERS.put(new ResourceLocation(shader.resourceLocation), (ShaderInstance)shaderInstance));
                DarkModeEverywhere.LOGGER.info("Registered shader " + shader.resourceLocation);
                loaderShaders.add(shader.resourceLocation);
            }
            catch (IOException e) {
                DarkModeEverywhere.LOGGER.trace((Object)e);
            }
        }
        if (CONFIG.getSelectedShader() != null) {
            SELECTED_SHADER = new ResourceLocation(CONFIG.getSelectedShader());
        }
    }

    @SubscribeEvent
    public void openGui(ScreenEvent.InitScreenEvent event) {
        if (Minecraft.m_91087_().f_91073_ != null && event.getScreen() instanceof AbstractContainerScreen) {
            event.addListener((GuiEventListener)new Button(60, event.getScreen().f_96544_ - 24, 60, 20, (Component)new TextComponent("Dark Mode"), but -> {
                int nextShader;
                SELECTED_SHADER = Screen.m_96638_() ? null : (SELECTED_SHADER == null ? (ResourceLocation)REGISTERED_SHADERS.keySet().toArray()[0] : ((nextShader = new ArrayList<ResourceLocation>(REGISTERED_SHADERS.keySet()).indexOf(SELECTED_SHADER) + 1) > REGISTERED_SHADERS.size() - 1 ? null : new ArrayList<ResourceLocation>(REGISTERED_SHADERS.keySet()).get(nextShader)));
                CONFIG.setSelectedShader(SELECTED_SHADER);
            }, (p_93753_, p_93754_, p_93755_, p_93756_) -> {
                ArrayList<Object> tooltip = new ArrayList<Object>();
                tooltip.add(SELECTED_SHADER == null ? new TextComponent("Light Mode") : new TextComponent(ClientProxy.SHADER_VALUES.get((Object)ClientProxy.SELECTED_SHADER).displayName));
                tooltip.add(new TextComponent(" * Use shift to change it to Light Mode").m_130940_(ChatFormatting.GRAY));
                event.getScreen().m_96597_(p_93754_, tooltip, p_93755_, p_93756_);
            }));
        }
    }
}

