/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.block;

import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.block.CompactMachineTile;
import dev.compactmods.machines.config.ServerConfig;
import dev.compactmods.machines.core.EnumMachinePlayersBreakHandling;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.data.persistent.CompactMachineData;
import dev.compactmods.machines.reference.EnumMachineSize;
import dev.compactmods.machines.util.PlayerUtil;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class BlockCompactMachine
extends Block
implements EntityBlock {
    private final EnumMachineSize size;

    public BlockCompactMachine(EnumMachineSize size, BlockBehaviour.Properties props) {
        super(props);
        this.size = size;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        CompactMachineTile tile = (CompactMachineTile)worldIn.m_7702_(pos);
        float normalHardness = super.m_5880_(state, player, worldIn, pos);
        if (tile == null) {
            return normalHardness;
        }
        boolean hasPlayers = tile.hasPlayersInside();
        if (hasPlayers) {
            EnumMachinePlayersBreakHandling hand = (EnumMachinePlayersBreakHandling)((Object)ServerConfig.MACHINE_PLAYER_BREAK_HANDLING.get());
            switch (hand) {
                case UNBREAKABLE: {
                    return 0.0f;
                }
                case OWNER: {
                    Optional<UUID> ownerUUID = tile.getOwnerUUID();
                    return ownerUUID.map(uuid -> Float.valueOf(player.m_142081_() == uuid ? normalHardness : 0.0f)).orElse(Float.valueOf(normalHardness)).floatValue();
                }
                case ANYONE: {
                    return normalHardness;
                }
            }
        }
        return normalHardness;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return false;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return 0;
    }

    @ParametersAreNonnullByDefault
    public void m_6861_(BlockState state, Level world, BlockPos pos, Block changedBlock, BlockPos changedPos, boolean isMoving) {
        super.m_6861_(state, world, pos, changedBlock, changedPos, isMoving);
        if (world.f_46443_) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        BlockEntity blockEntity = serverWorld.m_7702_(pos);
        if (blockEntity instanceof CompactMachineTile) {
            CompactMachineTile machine = (CompactMachineTile)blockEntity;
            ServerLevel compactWorld = serverWorld.m_142572_().m_129880_(Registration.COMPACT_DIMENSION);
            if (compactWorld == null) {
                CompactMachines.LOGGER.warn("Warning: Compact Dimension was null! Cannot fetch internal state for machine neighbor change listener.");
            }
        }
    }

    public static Block getBySize(EnumMachineSize size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case EnumMachineSize.TINY -> (Block)Registration.MACHINE_BLOCK_TINY.get();
            case EnumMachineSize.SMALL -> (Block)Registration.MACHINE_BLOCK_SMALL.get();
            case EnumMachineSize.NORMAL -> (Block)Registration.MACHINE_BLOCK_NORMAL.get();
            case EnumMachineSize.LARGE -> (Block)Registration.MACHINE_BLOCK_LARGE.get();
            case EnumMachineSize.GIANT -> (Block)Registration.MACHINE_BLOCK_GIANT.get();
            case EnumMachineSize.MAXIMUM -> (Block)Registration.MACHINE_BLOCK_MAXIMUM.get();
        };
    }

    public static Item getItemBySize(EnumMachineSize size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case EnumMachineSize.TINY -> (Item)Registration.MACHINE_BLOCK_ITEM_TINY.get();
            case EnumMachineSize.SMALL -> (Item)Registration.MACHINE_BLOCK_ITEM_SMALL.get();
            case EnumMachineSize.NORMAL -> (Item)Registration.MACHINE_BLOCK_ITEM_NORMAL.get();
            case EnumMachineSize.LARGE -> (Item)Registration.MACHINE_BLOCK_ITEM_LARGE.get();
            case EnumMachineSize.GIANT -> (Item)Registration.MACHINE_BLOCK_ITEM_GIANT.get();
            case EnumMachineSize.MAXIMUM -> (Item)Registration.MACHINE_BLOCK_ITEM_MAXIMUM.get();
        };
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        Block given = BlockCompactMachine.getBySize(this.size);
        ItemStack stack = new ItemStack((ItemLike)given, 1);
        CompoundTag nbt = stack.m_41784_();
        CompactMachineTile tileEntity = (CompactMachineTile)world.m_7702_(pos);
        if (tileEntity != null && tileEntity.mapped()) {
            nbt.m_128405_("machine_id", tileEntity.machineId);
        }
        return stack;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (worldIn.m_5776_()) {
            return;
        }
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof CompactMachineTile) {
            CompactMachineTile tile = (CompactMachineTile)blockEntity;
            if (tile.machineId != -1) {
                return;
            }
            if (!stack.m_41782_()) {
                return;
            }
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null) {
                return;
            }
            if (nbt.m_128441_("machine_id")) {
                int machineID = nbt.m_128451_("machine_id");
                tile.setMachineId(machineID);
            }
            tile.doPostPlaced();
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack mainItem = player.m_21205_();
            if (mainItem.m_41619_()) {
                return InteractionResult.PASS;
            }
            if (mainItem.m_41720_() == Registration.PERSONAL_SHRINKING_DEVICE.get()) {
                PlayerUtil.teleportPlayerIntoMachine(serverPlayer, pos, this.size);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public EnumMachineSize getSize() {
        return this.size;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CompactMachineTile(pos, state);
    }

    public void m_6810_(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean a) {
        CompactMachineTile entity;
        MinecraftServer server = level.m_142572_();
        if (level.f_46443_ || server == null) {
            super.m_6810_(oldState, level, pos, newState, a);
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CompactMachineTile && (entity = (CompactMachineTile)blockEntity).mapped()) {
            CompactMachineData machines = CompactMachineData.get(server);
            machines.remove(entity.machineId);
        }
        super.m_6810_(oldState, level, pos, newState, a);
    }
}

