/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.block;

import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.data.persistent.CompactMachineData;
import dev.compactmods.machines.data.persistent.CompactRoomData;
import dev.compactmods.machines.data.persistent.MachineConnections;
import dev.compactmods.machines.teleportation.DimensionalPosition;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class CompactMachineTile
extends BlockEntity
implements ICapabilityProvider {
    public int machineId = -1;
    private final boolean initialized = false;
    public long nextSpawnTick = 0L;
    protected UUID owner;
    protected String schema;
    protected boolean locked = false;

    public CompactMachineTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.MACHINE_TILE_ENTITY.get(), pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.machineId = nbt.m_128451_("machine_id");
        this.owner = nbt.m_128441_("owner") ? nbt.m_128342_("owner") : null;
        this.nextSpawnTick = nbt.m_128454_("spawntick");
        this.schema = nbt.m_128441_("schema") ? nbt.m_128461_("schema") : null;
        this.locked = nbt.m_128441_("locked") ? nbt.m_128471_("locked") : false;
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("machine_id", this.machineId);
        if (this.owner != null) {
            nbt.m_128362_("owner", this.owner);
        }
        nbt.m_128356_("spawntick", this.nextSpawnTick);
        if (this.schema != null) {
            nbt.m_128359_("schema", this.schema);
        }
        nbt.m_128379_("locked", this.locked);
    }

    public CompoundTag m_5995_() {
        CompoundTag base = super.m_5995_();
        base.m_128405_("machine", this.machineId);
        if (this.f_58857_ instanceof ServerLevel && this.owner != null) {
            base.m_128362_("owner", this.owner);
        }
        return base;
    }

    public Optional<ChunkPos> getInternalChunkPos() {
        if (this.f_58857_ instanceof ServerLevel) {
            MinecraftServer serv = this.f_58857_.m_142572_();
            if (serv == null) {
                return Optional.empty();
            }
            MachineConnections connections = MachineConnections.get(serv);
            if (connections == null) {
                return Optional.empty();
            }
            return connections.graph.getConnectedRoom(this.machineId);
        }
        return Optional.empty();
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.machineId = tag.m_128451_("machine");
        if (tag.m_128441_("players")) {
            CompoundTag compoundTag = tag.m_128469_("players");
        }
        if (tag.m_128441_("owner")) {
            this.owner = tag.m_128342_("owner");
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        BlockState state = null;
        if (this.f_58857_ != null) {
            state = this.f_58857_.m_8055_(this.f_58858_);
        }
        super.onDataPacket(net, pkt);
    }

    public Optional<UUID> getOwnerUUID() {
        return Optional.ofNullable(this.owner);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public void setMachineId(int id) {
        this.machineId = id;
        this.m_6596_();
    }

    public boolean hasPlayersInside() {
        return false;
    }

    public void doPostPlaced() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        MinecraftServer serv = this.f_58857_.m_142572_();
        if (serv == null) {
            return;
        }
        DimensionalPosition dp = new DimensionalPosition((ResourceKey<Level>)this.f_58857_.m_46472_(), this.f_58858_);
        CompactMachineData extern = CompactMachineData.get(serv);
        extern.setMachineLocation(this.machineId, dp);
        this.m_6596_();
    }

    public boolean mapped() {
        return this.getInternalChunkPos().isPresent();
    }

    public Optional<DimensionalPosition> getSpawn() {
        if (this.f_58857_ instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)this.f_58857_;
            MinecraftServer serv = serverWorld.m_142572_();
            MachineConnections connections = MachineConnections.get(serv);
            if (connections == null) {
                return Optional.empty();
            }
            Optional<ChunkPos> connectedRoom = connections.graph.getConnectedRoom(this.machineId);
            if (!connectedRoom.isPresent()) {
                return Optional.empty();
            }
            CompactRoomData roomData = CompactRoomData.get(serv);
            if (roomData == null) {
                return Optional.empty();
            }
            ChunkPos chunk = connectedRoom.get();
            return Optional.ofNullable(roomData.getSpawn(chunk));
        }
        return Optional.empty();
    }
}

