/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.compat.theoneprobe.providers;

import com.mojang.authlib.GameProfile;
import dev.compactmods.machines.api.core.Tooltips;
import dev.compactmods.machines.block.BlockCompactMachine;
import dev.compactmods.machines.block.CompactMachineTile;
import dev.compactmods.machines.util.TranslationUtil;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CompactMachineProvider
implements IProbeInfoProvider {
    public ResourceLocation getID() {
        return new ResourceLocation("compactmachines", "machine");
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo info, Player player, Level level, BlockState blockState, IProbeHitData hitData) {
        Block block = blockState.m_60734_();
        if (!(block instanceof BlockCompactMachine)) {
            return;
        }
        BlockCompactMachine mach = (BlockCompactMachine)block;
        BlockEntity te = level.m_7702_(hitData.getPos());
        if (te instanceof CompactMachineTile) {
            CompactMachineTile machine = (CompactMachineTile)te;
            if (machine.mapped()) {
                MutableComponent id = TranslationUtil.tooltip(Tooltips.Machines.ID, machine.machineId).m_130940_(ChatFormatting.GREEN);
                info.text((Component)id);
            } else {
                MutableComponent newMachine = TranslationUtil.message(new ResourceLocation("compactmachines", "new_machine")).m_130940_(ChatFormatting.GREEN);
                info.text((Component)newMachine);
            }
            machine.getOwnerUUID().ifPresent(ownerID -> {
                Player owner = level.m_46003_(ownerID);
                if (owner != null) {
                    GameProfile ownerProfile = owner.m_36316_();
                    MutableComponent ownerText = TranslationUtil.tooltip(Tooltips.Machines.OWNER, ownerProfile.getName()).m_130940_(ChatFormatting.GRAY);
                    info.text((Component)ownerText);
                }
            });
        }
    }
}

