/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.core;

import dev.compactmods.machines.api.tunnels.TunnelDefinition;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.item.TunnelItem;
import dev.compactmods.machines.tunnel.TunnelWallBlock;
import dev.compactmods.machines.tunnel.TunnelWallEntity;
import dev.compactmods.machines.tunnel.UnknownTunnel;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class Tunnels {
    public static final DeferredRegister<TunnelDefinition> DEFINITIONS = DeferredRegister.create(TunnelDefinition.class, (String)"compactmachines");
    public static final Supplier<IForgeRegistry<TunnelDefinition>> TUNNEL_DEF_REGISTRY = DEFINITIONS.makeRegistry("tunnel_types", () -> new RegistryBuilder().setType(TunnelDefinition.class).tagFolder("tunnel_types"));
    public static final RegistryObject<TunnelDefinition> UNKNOWN = DEFINITIONS.register("unknown", UnknownTunnel::new);
    public static final RegistryObject<Item> ITEM_TUNNEL = Registration.ITEMS.register("tunnel", () -> new TunnelItem(Registration.BASIC_ITEM_PROPS.get()));
    public static final RegistryObject<Block> BLOCK_TUNNEL_WALL = Registration.BLOCKS.register("tunnel_wall", () -> new TunnelWallBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76407_).m_60913_(-1.0f, 3600000.8f).m_60918_(SoundType.f_56743_).m_60953_(state -> 15).m_60993_()));
    public static final RegistryObject<BlockEntityType<TunnelWallEntity>> TUNNEL_BLOCK_ENTITY = Registration.BLOCK_ENTITIES.register("tunnel_wall", () -> BlockEntityType.Builder.m_155273_(TunnelWallEntity::new, (Block[])new Block[]{(Block)BLOCK_TUNNEL_WALL.get()}).m_58966_(null));

    public static void init(IEventBus bus) {
        DEFINITIONS.register(bus);
    }

    public static boolean isRegistered(ResourceLocation id) {
        return TUNNEL_DEF_REGISTRY.get().containsKey(id);
    }

    public static TunnelDefinition getDefinition(ResourceLocation id) {
        return Tunnels.isRegistered(id) ? (TunnelDefinition)TUNNEL_DEF_REGISTRY.get().getValue(id) : (TunnelDefinition)UNKNOWN.get();
    }
}

