/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.data.graph;

import com.google.common.collect.ImmutableList;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.machines.data.codec.CodecExtensions;
import dev.compactmods.machines.data.graph.CompactMachineNode;
import dev.compactmods.machines.data.graph.CompactMachineRoomNode;
import dev.compactmods.machines.data.graph.DefaultEdges;
import dev.compactmods.machines.data.graph.IGraphEdge;
import dev.compactmods.machines.data.graph.IMachineGraphNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.level.ChunkPos;

public class CompactMachineConnectionGraph {
    private final MutableValueGraph<IMachineGraphNode, IGraphEdge> graph = ValueGraphBuilder.directed().nodeOrder(ElementOrder.sorted(Comparator.comparing(IMachineGraphNode::getId))).build();
    private final Map<Integer, CompactMachineNode> machines = new HashMap<Integer, CompactMachineNode>();
    private final Map<ChunkPos, CompactMachineRoomNode> rooms = new HashMap<ChunkPos, CompactMachineRoomNode>();
    public static final Codec<CompactMachineConnectionGraph> CODEC = RecordCodecBuilder.create(i -> i.group((App)CompactMachineConnectionInfo.CODEC.listOf().fieldOf("connections").forGetter(CompactMachineConnectionGraph::buildConnections)).apply((Applicative)i, CompactMachineConnectionGraph::new));

    public CompactMachineConnectionGraph() {
    }

    private CompactMachineConnectionGraph(List<CompactMachineConnectionInfo> connections) {
        this();
        for (CompactMachineConnectionInfo i : connections) {
            this.addRoom(i.roomChunk);
            for (int connectedMachine : i.machines()) {
                this.addMachine(connectedMachine);
                this.connectMachineToRoom(connectedMachine, i.roomChunk);
            }
        }
    }

    private List<CompactMachineConnectionInfo> buildConnections() {
        ArrayList<CompactMachineConnectionInfo> result = new ArrayList<CompactMachineConnectionInfo>();
        this.rooms.forEach((chunk, node) -> {
            Collection<Integer> machines = this.getMachinesFor((ChunkPos)chunk);
            CompactMachineConnectionInfo roomInfo = new CompactMachineConnectionInfo((ChunkPos)chunk, machines);
            result.add(roomInfo);
        });
        return result;
    }

    public void addMachine(int machine) {
        if (this.machines.containsKey(machine)) {
            return;
        }
        CompactMachineNode node = new CompactMachineNode(machine);
        this.graph.addNode((Object)node);
        this.machines.put(machine, node);
    }

    public void addRoom(ChunkPos roomChunk) {
        if (this.rooms.containsKey(roomChunk)) {
            return;
        }
        CompactMachineRoomNode node = new CompactMachineRoomNode(roomChunk);
        this.graph.addNode((Object)node);
        this.rooms.put(roomChunk, node);
    }

    public void connectMachineToRoom(int machine, ChunkPos room) {
        if (!this.machines.containsKey(machine)) {
            return;
        }
        if (!this.rooms.containsKey(room)) {
            return;
        }
        CompactMachineNode machineNode = this.machines.get(machine);
        CompactMachineRoomNode roomNode = this.rooms.get(room);
        this.graph.putEdgeValue((Object)machineNode, (Object)roomNode, (Object)DefaultEdges.MACHINE_LINK);
    }

    public Collection<Integer> getMachinesFor(ChunkPos machineChunk) {
        CompactMachineRoomNode node = this.rooms.get(machineChunk);
        if (node == null) {
            return Collections.emptySet();
        }
        Set inbound = this.graph.predecessors((Object)node);
        return inbound.stream().filter(ibn -> ibn instanceof CompactMachineNode).map(ibn -> (CompactMachineNode)ibn).map(CompactMachineNode::getMachineId).collect(Collectors.toSet());
    }

    public Optional<ChunkPos> getConnectedRoom(int machine) {
        if (!this.machines.containsKey(machine)) {
            return Optional.empty();
        }
        CompactMachineNode node = this.machines.get(machine);
        Set connected = this.graph.successors((Object)node);
        return connected.stream().filter(n -> n instanceof CompactMachineRoomNode).map(n -> (CompactMachineRoomNode)n).map(CompactMachineRoomNode::getChunk).findFirst();
    }

    public Stream<CompactMachineNode> getMachines() {
        return this.machines.values().stream();
    }

    private static class CompactMachineConnectionInfo {
        private final ChunkPos roomChunk;
        private final List<Integer> connectedMachines;
        public static final Codec<CompactMachineConnectionInfo> CODEC = RecordCodecBuilder.create(i -> i.group((App)CodecExtensions.CHUNKPOS.fieldOf("machine").forGetter(CompactMachineConnectionInfo::room), (App)Codec.INT.listOf().fieldOf("connections").forGetter(CompactMachineConnectionInfo::machines)).apply((Applicative)i, CompactMachineConnectionInfo::new));

        public CompactMachineConnectionInfo(ChunkPos roomChunk, Collection<Integer> connections) {
            this.roomChunk = roomChunk;
            this.connectedMachines = ImmutableList.copyOf(connections);
        }

        public ChunkPos room() {
            return this.roomChunk;
        }

        public List<Integer> machines() {
            return this.connectedMachines;
        }
    }
}

