/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.data.persistent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.location.IDimensionalPosition;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.data.codec.NbtListCollector;
import dev.compactmods.machines.teleportation.DimensionalPosition;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.common.util.LazyOptional;

public class CompactMachineData
extends SavedData {
    public static final String DATA_NAME = "compactmachines_machines";
    private final Map<Integer, MachineData> data = new HashMap<Integer, MachineData>();
    private final Map<Integer, LazyOptional<IDimensionalPosition>> locations = new HashMap<Integer, LazyOptional<IDimensionalPosition>>();

    @Nullable
    public static CompactMachineData get(MinecraftServer server) {
        ServerLevel compactWorld = server.m_129880_(Registration.COMPACT_DIMENSION);
        if (compactWorld == null) {
            CompactMachines.LOGGER.error("No compact dimension found. Report this.");
            return null;
        }
        DimensionDataStorage sd = compactWorld.m_8895_();
        return (CompactMachineData)sd.m_164861_(CompactMachineData::fromNbt, CompactMachineData::new, DATA_NAME);
    }

    public static CompactMachineData fromNbt(CompoundTag nbt) {
        CompactMachineData machines = new CompactMachineData();
        if (nbt.m_128441_("locations")) {
            ListTag nbtLocations = nbt.m_128437_("locations", 10);
            nbtLocations.forEach(nbtLoc -> {
                DataResult res = MachineData.CODEC.parse((DynamicOps)NbtOps.f_128958_, nbtLoc);
                res.resultOrPartial(err -> CompactMachines.LOGGER.error("Error while processing machine data: " + err)).ifPresent(machineInfo -> machines.data.put(machineInfo.machineId, (MachineData)machineInfo));
            });
        }
        return machines;
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag nbt) {
        if (!this.data.isEmpty()) {
            ListTag nbtLocations = this.data.values().stream().map(entry -> {
                DataResult nbtRes = MachineData.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, entry);
                return nbtRes.resultOrPartial(err -> CompactMachines.LOGGER.error("Error serializing machine data: " + err));
            }).filter(Optional::isPresent).map(Optional::get).collect(NbtListCollector.toNbtList());
            nbt.m_128365_("locations", (Tag)nbtLocations);
        }
        return nbt;
    }

    public void setMachineLocation(int machineId, DimensionalPosition position) {
        if (this.data.containsKey(machineId)) {
            this.data.get(machineId).setLocation(position);
        } else {
            this.data.put(machineId, new MachineData(machineId, position));
        }
        if (this.locations.containsKey(machineId)) {
            this.locations.get(machineId).invalidate();
            this.locations.remove(machineId);
        }
        this.m_77762_();
    }

    public LazyOptional<IDimensionalPosition> getMachineLocation(int machineId) {
        if (!this.data.containsKey(machineId)) {
            return LazyOptional.empty();
        }
        if (this.locations.containsKey(machineId)) {
            return this.locations.get(machineId);
        }
        LazyOptional lazy = LazyOptional.of(() -> {
            MachineData machineData = this.data.get(machineId);
            return machineData.location;
        });
        this.locations.put(machineId, (LazyOptional<IDimensionalPosition>)lazy);
        return lazy;
    }

    public void remove(int id) {
        MachineData removed = this.data.remove(id);
        if (removed != null) {
            this.m_77762_();
        }
    }

    public static class MachineData {
        private final int machineId;
        public DimensionalPosition location;
        public static final Codec<MachineData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("machine").forGetter(MachineData::getMachineId), (App)DimensionalPosition.CODEC.fieldOf("location").forGetter(MachineData::getLocation)).apply((Applicative)i, MachineData::new));

        public MachineData(int machineId, DimensionalPosition location) {
            this.machineId = machineId;
            this.location = location;
        }

        public int getMachineId() {
            return this.machineId;
        }

        public DimensionalPosition getLocation() {
            return this.location;
        }

        public void setLocation(DimensionalPosition position) {
            this.location = position;
        }
    }
}

