/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.data.persistent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.config.ServerConfig;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.data.codec.CodecExtensions;
import dev.compactmods.machines.data.codec.NbtListCollector;
import dev.compactmods.machines.reference.EnumMachineSize;
import dev.compactmods.machines.teleportation.DimensionalPosition;
import dev.compactmods.machines.util.MathUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.naming.OperationNotSupportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CompactRoomData
extends SavedData {
    public static final String DATA_NAME = "compactmachines_rooms";
    private final Map<ChunkPos, RoomData> machineData = new HashMap<ChunkPos, RoomData>();

    @Nullable
    public static CompactRoomData get(MinecraftServer server) {
        ServerLevel compactWorld = server.m_129880_(Registration.COMPACT_DIMENSION);
        if (compactWorld == null) {
            CompactMachines.LOGGER.error("No compact dimension found. Report this.");
            return null;
        }
        DimensionDataStorage sd = compactWorld.m_8895_();
        return (CompactRoomData)sd.m_164861_(CompactRoomData::fromNbt, CompactRoomData::new, DATA_NAME);
    }

    public static CompactRoomData fromNbt(CompoundTag nbt) {
        CompactRoomData data = new CompactRoomData();
        if (nbt.m_128441_("machines")) {
            ListTag machines = nbt.m_128437_("machines", 10);
            machines.forEach(machNbt -> {
                DataResult result = RoomData.CODEC.parse((DynamicOps)NbtOps.f_128958_, machNbt);
                result.resultOrPartial(err -> CompactMachines.LOGGER.error("Error loading machine data from file: {}", err)).ifPresent(imd -> {
                    ChunkPos chunk = new ChunkPos(imd.getCenter());
                    data.machineData.put(chunk, (RoomData)imd);
                });
            });
        }
        return data;
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag nbt) {
        if (!this.machineData.isEmpty()) {
            ListTag collect = this.machineData.values().stream().map(data -> {
                DataResult n = RoomData.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, data);
                return n.result();
            }).filter(Optional::isPresent).map(Optional::get).collect(NbtListCollector.toNbtList());
            nbt.m_128365_("machines", (Tag)collect);
        }
        return nbt;
    }

    public boolean isRegistered(ChunkPos chunkPos) {
        return this.machineData.containsKey(chunkPos);
    }

    private void register(ChunkPos pos, RoomData data) throws OperationNotSupportedException {
        if (this.isRegistered(pos)) {
            throw new OperationNotSupportedException("Machine already registered.");
        }
        this.machineData.put(pos, data);
        this.m_77762_();
    }

    @Nullable
    public DimensionalPosition getSpawn(ChunkPos roomChunk) {
        RoomData roomData = this.machineData.get(roomChunk);
        if (roomData == null) {
            return null;
        }
        return new DimensionalPosition(Registration.COMPACT_DIMENSION, roomData.getSpawn());
    }

    public int getNextId() {
        return this.machineData.size() + 1;
    }

    public void setSpawn(ChunkPos roomChunk, Vec3 position) {
        if (!this.machineData.containsKey(roomChunk)) {
            return;
        }
        RoomData roomData = this.machineData.get(roomChunk);
        roomData.setSpawn(position);
        this.m_77762_();
    }

    public Optional<AABB> getInnerBounds(ChunkPos roomChunk) {
        if (!this.machineData.containsKey(roomChunk)) {
            return Optional.empty();
        }
        AABB bounds = this.machineData.get(roomChunk).getMachineBounds();
        return Optional.of(bounds);
    }

    public NewRoomRegistration createNew() {
        return new NewRoomRegistration(this);
    }

    public boolean isMachineRoomChunk(ChunkPos pos) {
        return this.machineData.containsKey(pos);
    }

    private static class RoomData {
        public static final Codec<RoomData> CODEC = RecordCodecBuilder.create(i -> i.group((App)CodecExtensions.UUID_CODEC.fieldOf("owner").forGetter(RoomData::getOwner), (App)BlockPos.f_121852_.fieldOf("center").forGetter(RoomData::getCenter), (App)CodecExtensions.VECTOR3D.fieldOf("spawn").forGetter(RoomData::getSpawn), (App)EnumMachineSize.CODEC.fieldOf("size").forGetter(RoomData::getSize)).apply((Applicative)i, RoomData::new));
        private final UUID owner;
        private final BlockPos center;
        private Vec3 spawn;
        private final EnumMachineSize size;

        public RoomData(UUID owner, BlockPos center, Vec3 spawn, EnumMachineSize size) {
            this.owner = owner;
            this.center = center;
            this.spawn = spawn;
            this.size = size;
        }

        private EnumMachineSize getSize() {
            return this.size;
        }

        public UUID getOwner() {
            return this.owner;
        }

        public Vec3 getSpawn() {
            if (this.spawn != null) {
                return this.spawn;
            }
            Vec3 newSpawn = new Vec3((double)this.center.m_123341_(), (double)this.center.m_123342_(), (double)this.center.m_123343_());
            double offset = (double)this.size.getInternalSize() / 2.0;
            this.spawn = newSpawn.m_82492_(0.0, offset, 0.0);
            return this.spawn;
        }

        public BlockPos getCenter() {
            return this.center;
        }

        public void setSpawn(Vec3 newSpawn) {
            this.spawn = newSpawn;
        }

        public AABB getMachineBounds() {
            return this.size.getBounds(this.center);
        }
    }

    public static class NewRoomRegistration {
        private final CompactRoomData storage;
        private Vec3 spawn;
        private ChunkPos chunk = new ChunkPos(0, 0);
        private EnumMachineSize size = EnumMachineSize.TINY;
        private BlockPos center = BlockPos.f_121853_;
        private UUID owner;

        public NewRoomRegistration(CompactRoomData storage) {
            this.storage = storage;
        }

        private void recalculateSize() {
            BlockPos centerAtFloor = MathUtil.getCenterWithY(this.chunk, (int)((Integer)ServerConfig.MACHINE_FLOOR_Y.get()));
            BlockPos centerSized = centerAtFloor.m_6630_(this.size.getInternalSize() / 2);
            this.spawn = new Vec3((double)centerAtFloor.m_123341_(), (double)centerAtFloor.m_123342_(), (double)centerAtFloor.m_123343_());
            this.center = centerSized;
        }

        public NewRoomRegistration owner(UUID owner) {
            this.owner = owner;
            return this;
        }

        public NewRoomRegistration size(EnumMachineSize size) {
            this.size = size;
            this.recalculateSize();
            return this;
        }

        public NewRoomRegistration spawn(BlockPos spawn) {
            Vec3 spawnTest = new Vec3((double)spawn.m_123341_(), (double)spawn.m_123342_(), (double)spawn.m_123343_());
            if (this.size.getBounds(this.center).m_82390_(spawnTest)) {
                this.spawn = spawnTest;
            }
            return this;
        }

        public NewRoomRegistration chunk(ChunkPos chunk) {
            this.chunk = chunk;
            this.recalculateSize();
            return this;
        }

        public void register() throws OperationNotSupportedException {
            RoomData data = new RoomData(this.owner, this.center, this.spawn, this.size);
            this.storage.register(this.chunk, data);
        }
    }
}

