/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.datagen;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.advancement.trigger.ClaimedMachineTrigger;
import dev.compactmods.machines.advancement.trigger.HowDidYouGetHereTrigger;
import dev.compactmods.machines.api.core.Advancements;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.util.TranslationUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class AdvancementGenerator
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public AdvancementGenerator(DataGenerator gen) {
        this.generator = gen;
    }

    public void m_6865_(@NotNull HashCache cache) {
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = adv -> {
            if (!set.add(adv.m_138327_())) {
                throw new IllegalStateException("Duplicate advancement " + adv.m_138327_());
            }
            Path path1 = path.resolve("data/" + adv.m_138327_().m_135827_() + "/advancements/" + adv.m_138327_().m_135815_() + ".json");
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)adv.m_138313_().m_138400_(), (Path)path1);
            }
            catch (IOException ioexception) {
                CompactMachines.LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
            }
        };
        this.generateAdvancements(consumer);
    }

    private ResourceLocation modLoc(String i) {
        return new ResourceLocation("compactmachines", i);
    }

    private void generateAdvancements(Consumer<Advancement> consumer) {
        Advancement root = Advancement.Builder.m_138353_().m_138386_("root", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_138358_(new DisplayBuilder().frame(FrameType.TASK).background(this.modLoc("textures/block/wall.png")).item(new ItemStack((ItemLike)Registration.MACHINE_BLOCK_ITEM_NORMAL.get())).id(Advancements.ROOT).toast(false).hidden(false).chat(false).build()).m_138389_(consumer, this.modLoc("root").toString());
        Advancement.Builder.m_138353_().m_138398_(root).m_138386_("got_stuck", (CriterionTriggerInstance)HowDidYouGetHereTrigger.Instance.create()).m_138358_(new DisplayBuilder().frame(FrameType.CHALLENGE).item(new ItemStack((ItemLike)Registration.PERSONAL_SHRINKING_DEVICE.get())).id(Advancements.HOW_DID_YOU_GET_HERE).toast(false).hidden(true).build()).m_138389_(consumer, Advancements.HOW_DID_YOU_GET_HERE.toString());
        Advancement.Builder.m_138353_().m_138398_(root).m_138386_("obtained_wall", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)Registration.BLOCK_BREAKABLE_WALL.get()})).m_138358_(new DisplayBuilder().frame(FrameType.TASK).item(new ItemStack((ItemLike)Registration.BLOCK_BREAKABLE_WALL.get())).id(Advancements.FOUNDATIONS).build()).m_138389_(consumer, Advancements.FOUNDATIONS.toString());
        Advancement psd = Advancement.Builder.m_138353_().m_138398_(root).m_138386_("obtained_psd", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)Registration.PERSONAL_SHRINKING_DEVICE.get()})).m_138358_(new DisplayBuilder().frame(FrameType.TASK).item(new ItemStack((ItemLike)Registration.PERSONAL_SHRINKING_DEVICE.get())).id(Advancements.GOT_SHRINKING_DEVICE).build()).m_138389_(consumer, Advancements.GOT_SHRINKING_DEVICE.toString());
        this.machineAdvancement(consumer, psd, Advancements.CLAIMED_TINY_MACHINE, (Supplier<Item>)Registration.MACHINE_BLOCK_ITEM_TINY);
        this.machineAdvancement(consumer, psd, Advancements.CLAIMED_SMALL_MACHINE, (Supplier<Item>)Registration.MACHINE_BLOCK_ITEM_SMALL);
        this.machineAdvancement(consumer, psd, Advancements.CLAIMED_NORMAL_MACHINE, (Supplier<Item>)Registration.MACHINE_BLOCK_ITEM_NORMAL);
        this.machineAdvancement(consumer, psd, Advancements.CLAIMED_LARGE_MACHINE, (Supplier<Item>)Registration.MACHINE_BLOCK_ITEM_LARGE);
        this.machineAdvancement(consumer, psd, Advancements.CLAIMED_GIANT_MACHINE, (Supplier<Item>)Registration.MACHINE_BLOCK_ITEM_GIANT);
        this.machineAdvancement(consumer, psd, Advancements.CLAIMED_MAX_MACHINE, (Supplier<Item>)Registration.MACHINE_BLOCK_ITEM_MAXIMUM);
    }

    private void machineAdvancement(Consumer<Advancement> consumer, Advancement root, ResourceLocation advancement, Supplier<Item> item) {
        Advancement.Builder.m_138353_().m_138398_(root).m_138386_("claimed_machine", (CriterionTriggerInstance)ClaimedMachineTrigger.Instance.create(advancement)).m_138358_(new DisplayBuilder().frame(FrameType.TASK).item(new ItemStack((ItemLike)item.get())).id(advancement).build()).m_138389_(consumer, advancement.toString());
    }

    public String m_6055_() {
        return "CompactMachinesAdvancements";
    }

    private static class DisplayBuilder {
        private ItemStack stack;
        private ResourceLocation translationId;
        private boolean showToast = true;
        private boolean showInChat = true;
        private boolean isHidden = false;
        private ResourceLocation background = null;
        private FrameType frame = FrameType.TASK;

        public DisplayInfo build() {
            return new DisplayInfo(this.stack, (Component)TranslationUtil.advancementTitle(this.translationId), (Component)TranslationUtil.advancementDesc(this.translationId), this.background, this.frame, this.showToast, this.showInChat, this.isHidden);
        }

        public DisplayBuilder item(ItemStack item) {
            this.stack = item;
            return this;
        }

        public DisplayBuilder id(ResourceLocation transId) {
            this.translationId = transId;
            return this;
        }

        public DisplayBuilder toast(boolean toast) {
            this.showToast = toast;
            return this;
        }

        public DisplayBuilder chat(boolean chat) {
            this.showInChat = chat;
            return this;
        }

        public DisplayBuilder hidden(boolean hidden) {
            this.isHidden = hidden;
            return this;
        }

        public DisplayBuilder background(ResourceLocation resource) {
            this.background = resource;
            return this;
        }

        public DisplayBuilder frame(FrameType frame) {
            this.frame = frame;
            return this;
        }
    }
}

