/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.datagen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import dev.compactmods.machines.core.Registration;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class BlockLootGenerator
extends LootTableProvider {
    public BlockLootGenerator(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(Blocks::new, (Object)LootContextParamSets.f_81421_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, @NotNull ValidationContext val) {
        map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)val, (ResourceLocation)name, (LootTable)table));
    }

    private static class Blocks
    extends BlockLoot {
        private final LootItemFunction.Builder CopyOwnerAndReferenceFunction = CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("owner", "owner").m_80279_("machine_id", "machine_id");

        private Blocks() {
        }

        protected void addTables() {
            this.m_124165_((Block)Registration.BLOCK_BREAKABLE_WALL.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().name(((Block)Registration.BLOCK_BREAKABLE_WALL.get()).getRegistryName().toString()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ExplosionCondition.m_81661_()).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)Registration.ITEM_BREAKABLE_WALL.get())))));
            this.registerCompactMachineBlockDrops(Registration.MACHINE_BLOCK_TINY, Registration.MACHINE_BLOCK_ITEM_TINY);
            this.registerCompactMachineBlockDrops(Registration.MACHINE_BLOCK_SMALL, Registration.MACHINE_BLOCK_ITEM_SMALL);
            this.registerCompactMachineBlockDrops(Registration.MACHINE_BLOCK_NORMAL, Registration.MACHINE_BLOCK_ITEM_NORMAL);
            this.registerCompactMachineBlockDrops(Registration.MACHINE_BLOCK_LARGE, Registration.MACHINE_BLOCK_ITEM_LARGE);
            this.registerCompactMachineBlockDrops(Registration.MACHINE_BLOCK_GIANT, Registration.MACHINE_BLOCK_ITEM_GIANT);
            this.registerCompactMachineBlockDrops(Registration.MACHINE_BLOCK_MAXIMUM, Registration.MACHINE_BLOCK_ITEM_MAXIMUM);
        }

        private void registerCompactMachineBlockDrops(RegistryObject<Block> block, RegistryObject<Item> item) {
            LootPool.Builder builder = LootPool.m_79043_().name(((Block)block.get()).getRegistryName().toString()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ExplosionCondition.m_81661_()).m_5577_(this.CopyOwnerAndReferenceFunction).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)item.get())));
            this.m_124165_((Block)block.get(), LootTable.m_79147_().m_79161_(builder));
        }

        protected Iterable<Block> getKnownBlocks() {
            return ImmutableList.of((Object)((Block)Registration.BLOCK_BREAKABLE_WALL.get()), (Object)((Block)Registration.MACHINE_BLOCK_TINY.get()), (Object)((Block)Registration.MACHINE_BLOCK_SMALL.get()), (Object)((Block)Registration.MACHINE_BLOCK_NORMAL.get()), (Object)((Block)Registration.MACHINE_BLOCK_LARGE.get()), (Object)((Block)Registration.MACHINE_BLOCK_GIANT.get()), (Object)((Block)Registration.MACHINE_BLOCK_MAXIMUM.get()));
        }
    }
}

