/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.datagen;

import dev.compactmods.machines.datagen.AdvancementGenerator;
import dev.compactmods.machines.datagen.BlockLootGenerator;
import dev.compactmods.machines.datagen.ItemModelGenerator;
import dev.compactmods.machines.datagen.LevelBiomeGenerator;
import dev.compactmods.machines.datagen.RecipeGenerator;
import dev.compactmods.machines.datagen.StateGenerator;
import dev.compactmods.machines.datagen.TagGenerator;
import dev.compactmods.machines.datagen.TunnelWallStateGenerator;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(modid="compactmachines", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGeneration {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        if (event.includeServer()) {
            DataGeneration.registerServerProviders(event.getGenerator(), event);
        }
        if (event.includeClient()) {
            DataGeneration.registerClientProviders(event.getGenerator(), event);
        }
    }

    private static void registerServerProviders(DataGenerator generator, GatherDataEvent event) {
        ExistingFileHelper helper = event.getExistingFileHelper();
        generator.m_123914_((DataProvider)new LevelBiomeGenerator(generator));
        generator.m_123914_((DataProvider)new BlockLootGenerator(generator));
        generator.m_123914_((DataProvider)new RecipeGenerator(generator));
        generator.m_123914_((DataProvider)new AdvancementGenerator(generator));
        generator.m_123914_((DataProvider)new TagGenerator(generator, helper));
    }

    private static void registerClientProviders(DataGenerator generator, GatherDataEvent event) {
        ExistingFileHelper helper = event.getExistingFileHelper();
        generator.m_123914_((DataProvider)new StateGenerator(generator, helper));
        generator.m_123914_((DataProvider)new TunnelWallStateGenerator(generator, helper));
        generator.m_123914_((DataProvider)new ItemModelGenerator(generator, helper));
    }
}

