/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.datagen;

import java.util.OptionalLong;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.dimension.DimensionType;

public class DimensionTypeBuilder {
    private OptionalLong fixedTime = OptionalLong.empty();
    private boolean hasSkylight = true;
    private boolean hasCeiling = false;
    private boolean ultraWarm = false;
    private boolean natural = true;
    private double coordinateScale = 1.0;
    private boolean piglinSafe = false;
    private boolean bedWorks = true;
    private boolean respawnAnchorWorks = false;
    private boolean hasRaids = true;
    private int minY = 0;
    private int height = 256;
    private int logicalHeight = 256;
    private ResourceLocation infiniburn = BlockTags.f_13058_.m_6979_();
    private ResourceLocation effectsLocation = DimensionType.f_63840_;
    private float ambientLight = 0.0f;

    public DimensionTypeBuilder() {
        this.fixedTime = OptionalLong.empty();
    }

    public DimensionTypeBuilder fixedTime(long time) {
        this.fixedTime = OptionalLong.of(time);
        return this;
    }

    public DimensionTypeBuilder skylight(boolean skylight) {
        this.hasSkylight = skylight;
        return this;
    }

    public DimensionTypeBuilder ceiling(boolean hasCeiling) {
        this.hasCeiling = hasCeiling;
        return this;
    }

    public DimensionTypeBuilder ultraWarm(boolean ultraWarm) {
        this.ultraWarm = ultraWarm;
        return this;
    }

    public DimensionTypeBuilder natural(boolean natural) {
        this.natural = natural;
        return this;
    }

    public DimensionTypeBuilder coordScale(float coordinateScale) {
        this.coordinateScale = coordinateScale;
        return this;
    }

    public DimensionTypeBuilder piglinSafe(boolean piglins) {
        this.piglinSafe = piglins;
        return this;
    }

    public DimensionTypeBuilder bedWorks(boolean beds) {
        this.bedWorks = beds;
        return this;
    }

    public DimensionTypeBuilder respawnAnchorWorks(boolean respawn) {
        this.respawnAnchorWorks = respawn;
        return this;
    }

    public DimensionTypeBuilder raids(boolean raids) {
        this.hasRaids = raids;
        return this;
    }

    public DimensionTypeBuilder heightBounds(int min, int height) {
        return this.heightBounds(min, height, height);
    }

    public DimensionTypeBuilder heightBounds(int min, int height, int logicalHeight) {
        this.minY = min;
        this.height = height;
        this.logicalHeight = logicalHeight;
        return this;
    }

    public DimensionTypeBuilder infiniburn(ResourceLocation infiburn) {
        this.infiniburn = infiburn;
        return this;
    }

    public DimensionTypeBuilder effects(ResourceLocation effects) {
        this.effectsLocation = effects;
        return this;
    }

    public DimensionTypeBuilder ambientLight(float light) {
        this.ambientLight = light;
        return this;
    }

    public DimensionType build() {
        return DimensionType.m_188324_((OptionalLong)this.fixedTime, (boolean)this.hasSkylight, (boolean)this.hasCeiling, (boolean)this.ultraWarm, (boolean)this.natural, (double)this.coordinateScale, (boolean)false, (boolean)this.piglinSafe, (boolean)this.bedWorks, (boolean)this.respawnAnchorWorks, (boolean)this.hasRaids, (int)this.minY, (int)this.height, (int)this.logicalHeight, (ResourceLocation)this.infiniburn, (ResourceLocation)this.effectsLocation, (float)this.ambientLight);
    }
}

