/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.datagen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.datagen.DimensionTypeBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.dimension.DimensionType;
import org.jetbrains.annotations.NotNull;

public class LevelBiomeGenerator
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final ResourceLocation COMPACT_BIOME = new ResourceLocation("compactmachines", "machine");

    LevelBiomeGenerator(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(@NotNull HashCache cache) {
        Path data = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        BiConsumer<Biome, ResourceLocation> biomeWriter = this.makeWriter(cache, data, (ImmutableSet<String>)ImmutableSet.of((Object)"worldgen", (Object)"biome"), Biome.f_47429_, set);
        BiConsumer<DimensionType, ResourceLocation> dimTypeWriter = this.makeWriter(cache, data, (ImmutableSet<String>)ImmutableSet.of((Object)"dimension_type"), DimensionType.f_63843_, set);
        this.writeBiomes(biomeWriter);
        this.writeDimensionTypes(dimTypeWriter);
    }

    private void writeDimensionTypes(BiConsumer<DimensionType, ResourceLocation> consumer) {
        DimensionType dim = new DimensionTypeBuilder().bedWorks(false).respawnAnchorWorks(false).fixedTime(18000L).natural(false).raids(false).heightBounds(0, 256).build();
        consumer.accept(dim, new ResourceLocation("compactmachines", "compact_world"));
    }

    private void writeBiomes(BiConsumer<Biome, ResourceLocation> biomeWriter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnBuilder);
        MobSpawnSettings spawns = spawnBuilder.m_48381_();
        Biome compactBiome = new Biome.BiomeBuilder().m_47595_(Biome.BiomeCategory.NONE).m_47611_(0.0f).m_47601_(BiomeGenerationSettings.f_47777_).m_47605_(spawns).m_47597_(Biome.Precipitation.NONE).m_47609_(0.8f).m_47599_(Biome.TemperatureModifier.NONE).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(-16777216).m_48018_()).m_47592_();
        compactBiome.setRegistryName(this.COMPACT_BIOME);
        biomeWriter.accept(compactBiome, this.COMPACT_BIOME);
    }

    private <T> BiConsumer<T, ResourceLocation> makeWriter(@NotNull HashCache cache, Path dataDir, ImmutableSet<String> pathParts, Codec<T> codec, Set<ResourceLocation> set) {
        return (resource, regName) -> {
            if (!set.add((ResourceLocation)regName)) {
                throw new IllegalStateException("Duplicate resource " + regName);
            }
            String namespace = regName.m_135827_();
            String path = regName.m_135815_();
            Path fileLocation = dataDir.resolve(Path.of("data", "compactmachines"));
            for (String p : pathParts) {
                fileLocation = fileLocation.resolve(p);
            }
            fileLocation = fileLocation.resolve(path + ".json");
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)((JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, resource).result().get()), (Path)fileLocation);
            }
            catch (IOException ioe) {
                CompactMachines.LOGGER.error("Couldn't save resource {}", (Object)fileLocation, (Object)ioe);
            }
        };
    }

    public String m_6055_() {
        return "compactmachines:levelgen";
    }
}

