/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.datagen;

import dev.compactmods.machines.core.Tunnels;
import dev.compactmods.machines.tunnel.TunnelWallBlock;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class TunnelWallStateGenerator
extends BlockStateProvider {
    public TunnelWallStateGenerator(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "compactmachines", exFileHelper);
    }

    protected void registerStatesAndModels() {
        Block block = (Block)Tunnels.BLOCK_TUNNEL_WALL.get();
        this.generateTunnelBaseModel();
        for (Direction dir : Direction.values()) {
            String typedTunnelDirectional = "tunnels/" + dir.m_7912_();
            ((BlockModelBuilder)this.models().withExistingParent(typedTunnelDirectional, this.modLoc("tunnels/base"))).texture("wall", this.modLoc("block/" + typedTunnelDirectional));
            this.getVariantBuilder(block).partialState().with((Property)TunnelWallBlock.CONNECTED_SIDE, (Comparable)dir).setModels(ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(typedTunnelDirectional))).build());
        }
    }

    private void generateTunnelBaseModel() {
        BlockModelBuilder base = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("tunnels/base", new ResourceLocation("minecraft", "block/block"))).texture("tunnel", this.modLoc("block/tunnels/tunnel"))).texture("indicator", this.modLoc("block/tunnels/indicator"));
        this.addFullCubeWithTexture(base, "#wall", -1);
        this.addFullCubeWithTexture(base, "#tunnel", 0);
        this.addFullCubeWithTexture(base, "#indicator", 1);
    }

    private void addFullCubeWithTexture(BlockModelBuilder base, String texture, int tintIndex) {
        base.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).allFaces((direction, faceBuilder) -> {
            ModelBuilder.ElementBuilder.FaceBuilder f = faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).cullface(direction);
            if (tintIndex > -1) {
                f.tintindex(tintIndex);
            }
            f.texture(texture).end();
        }).end();
    }
}

