/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.item;

import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.core.Messages;
import dev.compactmods.machines.api.core.Tooltips;
import dev.compactmods.machines.api.location.IDimensionalPosition;
import dev.compactmods.machines.api.tunnels.TunnelDefinition;
import dev.compactmods.machines.api.tunnels.redstone.IRedstoneTunnel;
import dev.compactmods.machines.core.Capabilities;
import dev.compactmods.machines.core.Tunnels;
import dev.compactmods.machines.data.persistent.CompactMachineData;
import dev.compactmods.machines.network.NetworkHandler;
import dev.compactmods.machines.network.TunnelAddedPacket;
import dev.compactmods.machines.rooms.capability.IRoomHistory;
import dev.compactmods.machines.tunnel.TunnelHelper;
import dev.compactmods.machines.tunnel.TunnelWallBlock;
import dev.compactmods.machines.tunnel.TunnelWallEntity;
import dev.compactmods.machines.tunnel.UnknownTunnel;
import dev.compactmods.machines.util.PlayerUtil;
import dev.compactmods.machines.util.TranslationUtil;
import dev.compactmods.machines.wall.SolidWallBlock;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public class TunnelItem
extends Item {
    public TunnelItem(Item.Properties properties) {
        super(properties);
    }

    public Component m_7626_(ItemStack stack) {
        String key = TunnelItem.getDefinition(stack).map(def -> {
            ResourceLocation id = def.getRegistryName();
            return "item." + id.m_135827_() + ".tunnels." + id.m_135815_().replace('/', '.');
        }).orElse("item.compactmachines.tunnels.unnamed");
        return new TranslatableComponent(key);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        TunnelItem.getDefinition(stack).ifPresent(tunnelDef -> {
            if (Screen.m_96638_()) {
                MutableComponent type = new TranslatableComponent("tooltip.compactmachines.tunnel_type", new Object[]{tunnelDef.getRegistryName()}).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC);
                tooltip.add((Component)type);
            } else {
                tooltip.add((Component)TranslationUtil.tooltip(Tooltips.HINT_HOLD_SHIFT).m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
            }
        });
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            IForgeRegistry definitions = RegistryManager.ACTIVE.getRegistry(TunnelDefinition.class);
            definitions.getValues().forEach(def -> {
                if (def instanceof UnknownTunnel) {
                    return;
                }
                ItemStack withDef = new ItemStack((ItemLike)this, 1);
                CompoundTag defTag = withDef.m_41698_("definition");
                defTag.m_128359_("id", def.getRegistryName().toString());
                items.add((Object)withDef);
            });
        }
    }

    public static Optional<TunnelDefinition> getDefinition(ItemStack stack) {
        CompoundTag defTag = stack.m_41698_("definition");
        if (defTag.m_128456_() || !defTag.m_128441_("id")) {
            return Optional.empty();
        }
        ResourceLocation defId = new ResourceLocation(defTag.m_128461_("id"));
        IForgeRegistry tunnelReg = RegistryManager.ACTIVE.getRegistry(TunnelDefinition.class);
        if (!tunnelReg.containsKey(defId)) {
            return Optional.empty();
        }
        return Optional.ofNullable((TunnelDefinition)tunnelReg.getValue(defId));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.m_43723_();
        BlockPos position = context.m_8083_();
        BlockState state = level.m_8055_(position);
        if (state.m_60734_() instanceof SolidWallBlock && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TunnelItem.getDefinition(context.m_43722_()).ifPresent(def -> {
                try {
                    boolean success = TunnelItem.setupTunnelWall(level, position, context.m_43719_(), serverPlayer, def);
                    if (success && !player.m_7500_()) {
                        context.m_43722_().m_41774_(1);
                    }
                }
                catch (Exception e) {
                    CompactMachines.LOGGER.error((Object)e);
                }
            });
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    private static boolean setupTunnelWall(Level level, BlockPos position, Direction side, ServerPlayer player, TunnelDefinition def) throws Exception {
        boolean redstone = def instanceof IRedstoneTunnel;
        LazyOptional history = player.getCapability(Capabilities.ROOM_HISTORY);
        if (!history.isPresent()) {
            PlayerUtil.howDidYouGetThere(player);
            return false;
        }
        IRoomHistory hist = (IRoomHistory)history.orElseThrow(() -> new Exception("Player machine history not found. If this is an error, report it."));
        if (!hist.hasHistory()) {
            PlayerUtil.howDidYouGetThere(player);
            return false;
        }
        int enteredThrough = hist.peek().getMachine();
        CompactMachineData data = CompactMachineData.get(player.f_8924_);
        LazyOptional<IDimensionalPosition> machLoc = data.getMachineLocation(enteredThrough);
        if (!machLoc.isPresent()) {
            CompactMachines.LOGGER.warn("Player does not appear to have entered room via a machine; history is empty. If this is an error, report it.");
            return false;
        }
        LevelChunk chunk = level.m_46745_(position);
        return chunk.getCapability(Capabilities.ROOM_TUNNELS).map(room -> {
            Set existingOfType = room.stream(def).map(arg_0 -> ((Level)level).m_7702_(arg_0)).filter(be -> be instanceof TunnelWallEntity).map(be -> (TunnelWallEntity)((Object)((Object)be))).collect(Collectors.toSet());
            Set sides = existingOfType.stream().map(TunnelWallEntity::getTunnelSide).collect(Collectors.toSet());
            Optional<Direction> firstAvailable = TunnelHelper.getOrderedSides().filter(s -> !sides.contains(s)).findFirst();
            if (firstAvailable.isEmpty()) {
                player.m_6352_((Component)TranslationUtil.message(Messages.NO_TUNNEL_SIDE).m_130940_(ChatFormatting.DARK_RED), Util.f_137441_);
                return false;
            }
            Direction first = firstAvailable.get();
            BlockState tunnelState = (BlockState)((BlockState)((BlockState)((Block)Tunnels.BLOCK_TUNNEL_WALL.get()).m_49966_().m_61124_((Property)TunnelWallBlock.TUNNEL_SIDE, (Comparable)side)).m_61124_((Property)TunnelWallBlock.CONNECTED_SIDE, (Comparable)first)).m_61124_((Property)TunnelWallBlock.REDSTONE, (Comparable)Boolean.valueOf(redstone));
            level.m_7731_(position, tunnelState, 3);
            chunk.getCapability(Capabilities.ROOM_TUNNELS).ifPresent(roomTunn -> roomTunn.register(def, position));
            BlockEntity patt8989$temp = level.m_7702_(position);
            if (patt8989$temp instanceof TunnelWallEntity) {
                TunnelWallEntity tun = (TunnelWallEntity)patt8989$temp;
                try {
                    tun.setTunnelType(def);
                    tun.setConnectedTo(enteredThrough);
                    level.m_142572_().m_18689_(() -> NetworkHandler.MAIN_CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(position)), (Object)new TunnelAddedPacket(position, def)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }).orElse(false);
    }
}

