/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.rooms.capability;

import dev.compactmods.machines.api.tunnels.TunnelDefinition;
import dev.compactmods.machines.api.tunnels.connection.IRoomTunnels;
import dev.compactmods.machines.api.tunnels.connection.ITunnelConnection;
import dev.compactmods.machines.tunnel.TunnelWallEntity;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;

public class MachineRoomTunnels
implements IRoomTunnels {
    private final LevelChunk chunk;
    private final HashMap<BlockPos, TunnelDefinition> tunnels;

    public MachineRoomTunnels(LevelChunk chunk) {
        this.chunk = chunk;
        this.tunnels = new HashMap();
    }

    @Override
    public <T extends TunnelDefinition> boolean register(T type, BlockPos at) {
        if (this.tunnels.containsKey(at)) {
            return false;
        }
        this.tunnels.put(at, type);
        return true;
    }

    @Override
    public boolean unregister(BlockPos at) {
        if (!this.tunnels.containsKey(at)) {
            return false;
        }
        this.tunnels.remove(at);
        return true;
    }

    @Override
    public Stream<ITunnelConnection> stream() {
        return this.tunnels.keySet().stream().filter(pos -> this.chunk.m_8055_(pos).m_155947_()).map(arg_0 -> ((LevelChunk)this.chunk).m_7702_(arg_0)).filter(ent -> ent instanceof TunnelWallEntity).map(tunnel -> ((TunnelWallEntity)((Object)tunnel)).getConnection());
    }

    @Override
    public Optional<ITunnelConnection> locatedAt(BlockPos pos) {
        BlockEntity blockEntity;
        if (!this.tunnels.containsKey(pos)) {
            return Optional.empty();
        }
        if (this.chunk.m_8055_(pos).m_155947_() && (blockEntity = this.chunk.m_7702_(pos)) instanceof TunnelWallEntity) {
            TunnelWallEntity t = (TunnelWallEntity)blockEntity;
            return Optional.of(t.getConnection());
        }
        return Optional.empty();
    }

    @Override
    public Stream<BlockPos> stream(TunnelDefinition type) {
        return this.tunnels.keySet().stream().filter(pos -> this.tunnels.get(pos).getRegistryName() != null).filter(pos -> {
            ResourceLocation regName = this.tunnels.get(pos).getRegistryName();
            return regName != null && regName.equals((Object)type.getRegistryName());
        });
    }
}

