/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.rooms.capability;

import dev.compactmods.machines.api.room.IRoomCapabilities;
import dev.compactmods.machines.api.tunnels.TunnelDefinition;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.core.Direction;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class RoomChunkCapabilities
implements IRoomCapabilities {
    private final HashMap<TunnelDefinition, HashSet<Direction>> placedTunnels = new HashMap();

    public RoomChunkCapabilities(LevelChunk chunk) {
    }

    @Override
    public <CapType, TunnType extends TunnelDefinition> void addCapability(TunnType tunnel, Capability<CapType> capability, CapType instance, Direction side) {
        this.placedTunnels.putIfAbsent(tunnel, new HashSet());
        HashSet<Direction> sides = this.placedTunnels.get(tunnel);
        if (!sides.isEmpty() && sides.contains(side)) {
            return;
        }
        sides.add(side);
    }

    @Override
    public <CapType, TunnType extends TunnelDefinition> void removeCapability(TunnType tunnel, Capability<CapType> capability, Direction side) {
        if (!this.placedTunnels.containsKey(tunnel)) {
            return;
        }
        HashSet<Direction> sides = this.placedTunnels.get(tunnel);
        sides.remove(side);
    }

    @Override
    public <CapType, TunnType extends TunnelDefinition> LazyOptional<CapType> getCapability(TunnType tunnel, Capability<CapType> capability, Direction side) {
        if (side == null) {
            return LazyOptional.empty();
        }
        if (!this.placedTunnels.containsKey(tunnel) || this.placedTunnels.get(tunnel).contains(side)) {
            // empty if block
        }
        return LazyOptional.empty();
    }
}

