/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.rooms.capability;

import dev.compactmods.machines.api.room.IMachineRoom;
import dev.compactmods.machines.api.room.IRoomCapabilities;
import dev.compactmods.machines.api.tunnels.connection.IRoomTunnels;
import dev.compactmods.machines.core.Capabilities;
import dev.compactmods.machines.rooms.capability.MachineRoomTunnels;
import dev.compactmods.machines.rooms.capability.RoomChunkCapabilities;
import dev.compactmods.machines.rooms.capability.RoomChunkData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class RoomChunkDataProvider
implements ICapabilitySerializable<CompoundTag> {
    private final RoomChunkData room;
    private final RoomChunkCapabilities roomCaps;
    private final MachineRoomTunnels tunnels;

    public RoomChunkDataProvider(LevelChunk chunk) {
        this.room = new RoomChunkData(chunk);
        this.roomCaps = new RoomChunkCapabilities(chunk);
        this.tunnels = new MachineRoomTunnels(chunk);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.ROOM) {
            return LazyOptional.of(this::room).cast();
        }
        if (cap == Capabilities.ROOM_CAPS) {
            return LazyOptional.of(this::caps).cast();
        }
        if (cap == Capabilities.ROOM_TUNNELS) {
            return LazyOptional.of(this::tunnels).cast();
        }
        return LazyOptional.empty();
    }

    @Nonnull
    private IRoomTunnels tunnels() {
        return this.tunnels;
    }

    @NotNull
    private IRoomCapabilities caps() {
        return this.roomCaps;
    }

    @NotNull
    private IMachineRoom room() {
        return this.room;
    }

    public CompoundTag serializeNBT() {
        return new CompoundTag();
    }

    public void deserializeNBT(CompoundTag nbt) {
    }
}

