/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.tunnel;

import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.location.IDimensionalPosition;
import dev.compactmods.machines.api.room.IMachineRoom;
import dev.compactmods.machines.api.tunnels.TunnelDefinition;
import dev.compactmods.machines.api.tunnels.connection.ITunnelConnection;
import dev.compactmods.machines.api.tunnels.lifecycle.ITunnelSetup;
import dev.compactmods.machines.api.tunnels.lifecycle.ITunnelTeardown;
import dev.compactmods.machines.api.tunnels.lifecycle.TeardownReason;
import dev.compactmods.machines.core.Capabilities;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.core.Tunnels;
import dev.compactmods.machines.tunnel.TunnelMachineConnection;
import dev.compactmods.machines.tunnel.TunnelPosition;
import dev.compactmods.machines.tunnel.TunnelWallEntity;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.RegistryObject;

public class TunnelHelper {
    @Nonnull
    public static Direction getNextDirection(Direction in) {
        return switch (in) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> Direction.DOWN;
            case Direction.DOWN -> Direction.NORTH;
            case Direction.NORTH -> Direction.SOUTH;
            case Direction.SOUTH -> Direction.WEST;
            case Direction.WEST -> Direction.EAST;
            case Direction.EAST -> Direction.UP;
        };
    }

    @Nonnull
    public static Optional<TunnelDefinition> getTunnelDefinitionFromType(ResourceLocation id) {
        Optional<RegistryObject> first = Tunnels.DEFINITIONS.getEntries().stream().filter(t -> ((TunnelDefinition)t.get()).getRegistryName() == id).findFirst();
        return first.map(RegistryObject::get);
    }

    public static void teardown(MinecraftServer server, ITunnelConnection connectedPosition, BlockPos tunnelAt, ITunnelTeardown teardown, Direction side, TeardownReason reason) {
        ServerLevel level = server.m_129880_(Registration.COMPACT_DIMENSION);
        LevelChunk chunk = level.m_46745_(tunnelAt);
        LazyOptional room = chunk.getCapability(Capabilities.ROOM);
        if (!room.isPresent()) {
            CompactMachines.LOGGER.fatal("Error tearing down tunnel: required room data not present at {}", (Object)tunnelAt);
            return;
        }
        IMachineRoom r = (IMachineRoom)room.resolve().get();
        teardown.teardown(r, new TunnelPosition(level, tunnelAt, side), connectedPosition, reason);
    }

    public static void setup(MinecraftServer server, IDimensionalPosition position, BlockPos tunnelAt, ITunnelSetup setup, Direction side) {
        ServerLevel level = server.m_129880_(Registration.COMPACT_DIMENSION);
        LevelChunk chunk = level.m_46745_(tunnelAt);
        LazyOptional room = chunk.getCapability(Capabilities.ROOM);
        if (!room.isPresent()) {
            CompactMachines.LOGGER.fatal("Error setting up tunnel: required room data not present at {}", (Object)tunnelAt);
            return;
        }
        IMachineRoom r = (IMachineRoom)room.resolve().get();
        setup.setup(r, new TunnelPosition(level, tunnelAt, side), new TunnelMachineConnection(server, (TunnelWallEntity)chunk.m_7702_(tunnelAt)));
    }

    public static Stream<Direction> getOrderedSides() {
        return Stream.of(Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);
    }
}

