/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.tunnel;

import dev.compactmods.machines.api.location.IDimensionalPosition;
import dev.compactmods.machines.api.tunnels.connection.ITunnelConnection;
import dev.compactmods.machines.tunnel.TunnelWallEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TunnelMachineConnection
implements ITunnelConnection {
    private final ServerLevel level;
    private final BlockState state;
    private final Direction side;
    private final BlockPos position;

    public TunnelMachineConnection(MinecraftServer server, TunnelWallEntity tunnel) {
        IDimensionalPosition location = tunnel.getConnectedPosition();
        this.position = location.getBlockPosition();
        this.level = location.level(server).orElseThrow();
        this.state = location.state(server).orElse(Blocks.f_50016_.m_49966_());
        this.side = tunnel.getConnectedSide();
    }

    @Override
    @NotNull
    public ServerLevel level() {
        return this.level;
    }

    @Override
    @NotNull
    public BlockState state() {
        return this.state;
    }

    @Override
    @NotNull
    public Direction side() {
        return this.side;
    }

    @Override
    @NotNull
    public BlockPos position() {
        return this.position;
    }
}

