/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.tunnel;

import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.location.IDimensionalPosition;
import dev.compactmods.machines.api.room.IMachineRoom;
import dev.compactmods.machines.api.room.IRoomCapabilities;
import dev.compactmods.machines.api.tunnels.TunnelDefinition;
import dev.compactmods.machines.api.tunnels.connection.ITunnelConnection;
import dev.compactmods.machines.api.tunnels.lifecycle.ITunnelSetup;
import dev.compactmods.machines.api.tunnels.lifecycle.ITunnelTeardown;
import dev.compactmods.machines.api.tunnels.lifecycle.TeardownReason;
import dev.compactmods.machines.core.Capabilities;
import dev.compactmods.machines.core.Tunnels;
import dev.compactmods.machines.data.persistent.CompactMachineData;
import dev.compactmods.machines.data.persistent.MachineConnections;
import dev.compactmods.machines.tunnel.TunnelMachineConnection;
import dev.compactmods.machines.tunnel.TunnelPosition;
import dev.compactmods.machines.tunnel.TunnelWallBlock;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class TunnelWallEntity
extends BlockEntity {
    private int connectedMachine;
    private TunnelDefinition tunnelType;
    private final LazyOptional<ITunnelConnection> conn;
    private LazyOptional<IMachineRoom> ROOM = LazyOptional.empty();
    private LazyOptional<IRoomCapabilities> CAPS = LazyOptional.empty();
    private TunnelMachineConnection connection;

    public TunnelWallEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Tunnels.TUNNEL_BLOCK_ENTITY.get(), pos, state);
        this.tunnelType = (TunnelDefinition)Tunnels.UNKNOWN.get();
        this.conn = LazyOptional.of(this::getConnection);
    }

    public void m_155250_(@NotNull BlockState newState) {
        super.m_155250_(newState);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.connection = new TunnelMachineConnection(this.f_58857_.m_142572_(), this);
        }
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        try {
            if (nbt.m_128441_("tunnel_type")) {
                ResourceLocation type = new ResourceLocation(nbt.m_128461_("tunnel_type"));
                this.tunnelType = Tunnels.getDefinition(type);
            }
            if (nbt.m_128441_("machine")) {
                this.connectedMachine = nbt.m_128451_("machine");
            }
        }
        catch (Exception e) {
            this.tunnelType = (TunnelDefinition)Tunnels.UNKNOWN.get();
            this.connectedMachine = -1;
        }
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128359_("tunnel_type", this.tunnelType.getRegistryName().toString());
        compound.m_128405_("machine", this.connectedMachine);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128359_("tunnel_type", this.tunnelType.getRegistryName().toString());
        nbt.m_128405_("machine", this.connectedMachine);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (tag.m_128441_("tunnel_type")) {
            ResourceLocation id = new ResourceLocation(tag.m_128461_("tunnel_type"));
            this.tunnelType = Tunnels.getDefinition(id);
        }
        if (tag.m_128441_("machine")) {
            this.connectedMachine = tag.m_128451_("machine");
        }
        this.m_6596_();
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            this.connection = new TunnelMachineConnection(sl.m_142572_(), this);
            LevelChunk chunk = this.f_58857_.m_46745_(this.f_58858_);
            this.CAPS = chunk.getCapability(Capabilities.ROOM_CAPS);
            this.ROOM = chunk.getCapability(Capabilities.ROOM);
            TunnelDefinition tunnelDefinition = this.tunnelType;
            if (tunnelDefinition instanceof ITunnelSetup) {
                ITunnelSetup setup = (ITunnelSetup)((Object)tunnelDefinition);
                this.ROOM.ifPresent(room -> setup.setup((IMachineRoom)room, new TunnelPosition(sl, this.f_58858_, this.getTunnelSide()), this.connection));
            }
            this.ROOM = chunk.getCapability(Capabilities.ROOM).cast();
            this.CAPS = chunk.getCapability(Capabilities.ROOM_CAPS).cast();
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return super.getCapability(cap, side);
        }
        if (side != this.getTunnelSide()) {
            return super.getCapability(cap, side);
        }
        if (cap == Capabilities.TUNNEL_CONNECTION) {
            return this.conn.cast();
        }
        LevelChunk chunk = this.f_58857_.m_46745_(this.f_58858_);
        if (cap == Capabilities.ROOM) {
            return this.ROOM.cast();
        }
        if (cap == Capabilities.ROOM_CAPS) {
            return this.CAPS.cast();
        }
        return (LazyOptional)this.CAPS.lazyMap(caps -> caps.getCapability(this.tunnelType, cap, side)).orElseGet(() -> super.getCapability(cap, side));
    }

    @NotNull
    public ITunnelConnection getConnection() {
        if (this.connection == null) {
            this.connection = new TunnelMachineConnection(this.f_58857_.m_142572_(), this);
        }
        return this.connection;
    }

    public IDimensionalPosition getConnectedPosition() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return null;
        }
        MinecraftServer server = this.f_58857_.m_142572_();
        if (server == null) {
            return null;
        }
        CompactMachineData machines = CompactMachineData.get(server);
        MachineConnections conn = MachineConnections.get(server);
        if (machines == null || conn == null) {
            return null;
        }
        Collection<Integer> connected = conn.graph.getMachinesFor(new ChunkPos(this.f_58858_));
        Optional<Integer> first = connected.stream().findFirst();
        if (first.isEmpty()) {
            return null;
        }
        int machine = first.get();
        return machines.getMachineLocation(machine).map(dp -> dp.relative(this.getConnectedSide())).orElse(null);
    }

    public Direction getTunnelSide() {
        BlockState state = this.m_58900_();
        return (Direction)state.m_61143_((Property)TunnelWallBlock.TUNNEL_SIDE);
    }

    public Direction getConnectedSide() {
        BlockState blockState = this.m_58900_();
        return (Direction)blockState.m_61143_((Property)TunnelWallBlock.CONNECTED_SIDE);
    }

    public Optional<TunnelDefinition> getTunnelDefinition() {
        if (this.tunnelType == null) {
            return Optional.empty();
        }
        return Optional.of(this.tunnelType);
    }

    public void setTunnelType(TunnelDefinition type) throws Exception {
        Level level;
        if (type == this.tunnelType) {
            return;
        }
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || !((level = this.f_58857_) instanceof ServerLevel)) {
            this.tunnelType = type;
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        ITunnelConnection conn = this.getConnection();
        LevelChunk chunk = this.f_58857_.m_46745_(this.f_58858_);
        IMachineRoom roomData = (IMachineRoom)chunk.getCapability(Capabilities.ROOM).orElseThrow(() -> {
            CompactMachines.LOGGER.fatal("Failed to get room data off a chunk. This is a bug, report it!");
            return new Exception("Missing chunk room data.");
        });
        TunnelPosition p = new TunnelPosition(sl, this.f_58858_, this.getTunnelSide());
        TunnelDefinition tunnelDefinition = this.tunnelType;
        if (tunnelDefinition instanceof ITunnelTeardown) {
            ITunnelTeardown teardown = (ITunnelTeardown)((Object)tunnelDefinition);
            teardown.teardown(roomData, p, conn, TeardownReason.REMOVED);
        }
        if ((tunnelDefinition = (this.tunnelType = type)) instanceof ITunnelSetup) {
            ITunnelSetup setup = (ITunnelSetup)((Object)tunnelDefinition);
            setup.setup(roomData, p, conn);
        }
        this.m_6596_();
    }

    public TunnelDefinition getTunnelType() {
        return this.tunnelType;
    }

    public void setConnectedTo(int machine) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        CompactMachineData data = CompactMachineData.get(this.f_58857_.m_142572_());
        if (data == null) {
            return;
        }
        data.getMachineLocation(machine).ifPresent(p -> {
            this.connection = new TunnelMachineConnection(this.f_58857_.m_142572_(), this);
            this.conn.invalidate();
        });
    }
}

