/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.util;

import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.reference.EnumMachineSize;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class CompactStructureGenerator {
    public static void generateCompactWall(LevelAccessor world, EnumMachineSize size, BlockPos cubeCenter, Direction wallDirection) {
        boolean horiz;
        int s = size.getInternalSize() / 2;
        BlockState unbreakableWall = ((Block)Registration.BLOCK_SOLID_WALL.get()).m_49966_();
        BlockPos start = BlockPos.f_121853_;
        boolean bl = horiz = wallDirection.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL;
        if (horiz) {
            start = cubeCenter.m_6625_(s).m_5484_(wallDirection, s + 1);
            wallBounds = new AABB(start, start).m_82363_(0.0, (double)(s * 2 + 1), 0.0);
        } else {
            start = cubeCenter.m_5484_(wallDirection, s + 1);
            wallBounds = new AABB(start, start).m_82377_((double)(s + 1), 0.0, (double)(s + 1));
        }
        AABB wallBounds = switch (wallDirection) {
            case Direction.NORTH, Direction.SOUTH -> wallBounds.m_82377_((double)(s + 1), 0.0, 0.0);
            case Direction.WEST, Direction.EAST -> wallBounds.m_82377_(0.0, 0.0, (double)(s + 1));
        };
        BlockPos.m_121921_((AABB)wallBounds).filter(arg_0 -> ((LevelAccessor)world).m_46859_(arg_0)).map(BlockPos::m_7949_).forEach(p -> world.m_7731_(p, unbreakableWall, 7));
    }

    public static void generateCompactStructure(LevelAccessor world, EnumMachineSize size, BlockPos center) {
        int s = size.getInternalSize() / 2;
        BlockPos floorCenter = center.m_5484_(Direction.DOWN, s);
        AABB floorBlocks = new AABB(floorCenter, floorCenter).m_82377_((double)s, 0.0, (double)s);
        boolean anyAir = BlockPos.m_121921_((AABB)floorBlocks).anyMatch(arg_0 -> ((LevelAccessor)world).m_46859_(arg_0));
        if (anyAir) {
            Arrays.stream(Direction.values()).forEach(d -> CompactStructureGenerator.generateCompactWall(world, size, center, d));
        }
    }
}

