/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.util;

import com.mojang.authlib.GameProfile;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.advancement.AdvancementTriggers;
import dev.compactmods.machines.api.core.Messages;
import dev.compactmods.machines.block.CompactMachineTile;
import dev.compactmods.machines.config.ServerConfig;
import dev.compactmods.machines.core.Capabilities;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.data.persistent.CompactMachineData;
import dev.compactmods.machines.data.persistent.CompactRoomData;
import dev.compactmods.machines.data.persistent.MachineConnections;
import dev.compactmods.machines.reference.EnumMachineSize;
import dev.compactmods.machines.rooms.history.IRoomHistoryItem;
import dev.compactmods.machines.rooms.history.PlayerRoomHistoryItem;
import dev.compactmods.machines.teleportation.DimensionalPosition;
import dev.compactmods.machines.util.CompactStructureGenerator;
import dev.compactmods.machines.util.LocationUtil;
import dev.compactmods.machines.util.MathUtil;
import dev.compactmods.machines.util.TranslationUtil;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.naming.OperationNotSupportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;

public abstract class PlayerUtil {
    public static Optional<GameProfile> getProfileByUUID(LevelAccessor world, UUID uuid) {
        Player player = world.m_46003_(uuid);
        if (player == null) {
            return Optional.empty();
        }
        GameProfile profile = player.m_36316_();
        return Optional.of(profile);
    }

    public static DimensionalPosition getPlayerDimensionalPosition(Player player) {
        Vec3 pos = player.m_20182_();
        ResourceKey dim = player.f_19853_.m_46472_();
        return new DimensionalPosition((ResourceKey<Level>)dim, pos);
    }

    public static void teleportPlayerIntoMachine(ServerPlayer serverPlayer, BlockPos machinePos, EnumMachineSize size) {
        boolean grantAdvancement;
        ServerLevel serverWorld = serverPlayer.m_183503_();
        MinecraftServer serv = serverWorld.m_142572_();
        ServerLevel compactWorld = serv.m_129880_(Registration.COMPACT_DIMENSION);
        if (compactWorld == null) {
            CompactMachines.LOGGER.warn("Compact dimension not found; player attempted to enter machine.");
            return;
        }
        CompactMachineTile tile = (CompactMachineTile)serverWorld.m_7702_(machinePos);
        if (tile == null) {
            return;
        }
        boolean bl = grantAdvancement = !tile.mapped();
        if (!tile.mapped()) {
            CompactMachineData machines = CompactMachineData.get(serv);
            CompactRoomData rooms = CompactRoomData.get(serv);
            MachineConnections connections = MachineConnections.get(serv);
            if (machines == null || rooms == null || connections == null) {
                CompactMachines.LOGGER.error("Could not load world saved data while creating new machine and room.");
                return;
            }
            int nextId = rooms.getNextId();
            Vec3i location = MathUtil.getRegionPositionByIndex(nextId);
            int centerY = (Integer)ServerConfig.MACHINE_FLOOR_Y.get() + size.getInternalSize() / 2;
            BlockPos newCenter = MathUtil.getCenterWithY(location, centerY);
            CompactStructureGenerator.generateCompactStructure((LevelAccessor)compactWorld, size, newCenter);
            ChunkPos machineChunk = new ChunkPos(newCenter);
            tile.setMachineId(nextId);
            connections.graph.addMachine(nextId);
            connections.graph.addRoom(machineChunk);
            connections.graph.connectMachineToRoom(nextId, machineChunk);
            connections.m_77762_();
            machines.setMachineLocation(nextId, new DimensionalPosition((ResourceKey<Level>)serverWorld.m_46472_(), machinePos));
            try {
                rooms.createNew().owner(serverPlayer.m_142081_()).size(size).chunk(machineChunk).register();
            }
            catch (OperationNotSupportedException e) {
                CompactMachines.LOGGER.warn((Object)e);
            }
        }
        serv.m_18689_(() -> {
            DimensionalPosition spawn = tile.getSpawn().orElse(null);
            if (spawn == null) {
                CompactMachines.LOGGER.error("Machine " + tile.machineId + " could not load spawn info.");
                return;
            }
            try {
                PlayerUtil.addPlayerToMachine(serverPlayer, machinePos);
            }
            catch (Exception ex) {
                CompactMachines.LOGGER.error((Object)ex);
            }
            Vec3 sp = spawn.getPosition();
            Vec3 sr = spawn.getRotation() != Vec3.f_82478_ ? spawn.getRotation() : new Vec3((double)serverPlayer.f_19860_, (double)serverPlayer.f_19859_, 0.0);
            serverPlayer.m_8999_(compactWorld, sp.f_82479_, sp.f_82480_, sp.f_82481_, (float)sr.f_82480_, (float)sr.f_82479_);
            if (grantAdvancement) {
                AdvancementTriggers.getTriggerForMachineClaim(size).trigger(serverPlayer);
            }
        });
    }

    public static void teleportPlayerOutOfMachine(ServerLevel world, @Nonnull ServerPlayer serverPlayer) {
        MinecraftServer serv = world.m_142572_();
        LazyOptional history = serverPlayer.getCapability(Capabilities.ROOM_HISTORY);
        if (!history.isPresent()) {
            PlayerUtil.howDidYouGetThere(serverPlayer);
            return;
        }
        history.ifPresent(hist -> {
            ChunkPos currentRoomChunk = new ChunkPos(serverPlayer.m_142538_());
            if (hist.hasHistory()) {
                IRoomHistoryItem prevArea = hist.pop();
                DimensionalPosition spawnPoint = prevArea.getEntryLocation();
                ServerLevel w = spawnPoint.level(serv).orElse(serv.m_129783_());
                if (serv.m_129880_(spawnPoint.getDimension()) != null) {
                    Vec3 worldPos = spawnPoint.getPosition();
                    Vec3 entryRot = spawnPoint.getRotation();
                    serverPlayer.m_8999_(w, worldPos.m_7096_(), worldPos.m_7098_(), worldPos.m_7094_(), (float)entryRot.f_82480_, (float)entryRot.f_82479_);
                } else {
                    hist.clear();
                    PlayerUtil.teleportPlayerToRespawnOrOverworld(serv, serverPlayer);
                }
            } else {
                PlayerUtil.howDidYouGetThere(serverPlayer);
                hist.clear();
                PlayerUtil.teleportPlayerToRespawnOrOverworld(serv, serverPlayer);
            }
            LevelChunk chunk = serv.m_129880_(Registration.COMPACT_DIMENSION).m_6325_(currentRoomChunk.f_45578_, currentRoomChunk.f_45579_);
        });
    }

    public static void howDidYouGetThere(@Nonnull ServerPlayer serverPlayer) {
        AdvancementTriggers.HOW_DID_YOU_GET_HERE.trigger(serverPlayer);
        serverPlayer.m_5661_((Component)TranslationUtil.message(Messages.HOW_DID_YOU_GET_HERE), true);
    }

    public static void teleportPlayerToRespawnOrOverworld(MinecraftServer serv, @Nonnull ServerPlayer player) {
        ServerLevel level = Optional.ofNullable(serv.m_129880_(player.m_8963_())).orElse(serv.m_129783_());
        Vec3 worldPos = LocationUtil.blockPosToVector(level.m_8900_());
        if (player.m_8961_() != null) {
            worldPos = LocationUtil.blockPosToVector(player.m_8961_());
        }
        player.m_8999_(level, worldPos.m_7096_(), worldPos.m_7098_(), worldPos.m_7094_(), 0.0f, player.m_8962_());
    }

    public static void addPlayerToMachine(ServerPlayer serverPlayer, BlockPos machinePos) {
        MinecraftServer serv = serverPlayer.m_20194_();
        if (serv == null) {
            return;
        }
        CompactMachineTile tile = (CompactMachineTile)serverPlayer.m_183503_().m_7702_(machinePos);
        if (tile == null) {
            return;
        }
        tile.getInternalChunkPos().ifPresent(mChunk -> {
            LevelChunk chunk = serv.m_129880_(Registration.COMPACT_DIMENSION).m_6325_(mChunk.f_45578_, mChunk.f_45579_);
            serverPlayer.getCapability(Capabilities.ROOM_HISTORY).ifPresent(hist -> {
                DimensionalPosition pos = DimensionalPosition.fromEntity((LivingEntity)serverPlayer);
                hist.addHistory(new PlayerRoomHistoryItem(pos, tile.machineId));
            });
        });
    }
}

