/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.compat;

import edivad.extrastorage.Main;
import edivad.extrastorage.blocks.CrafterTier;
import edivad.extrastorage.items.storage.fluid.FluidStorageType;
import edivad.extrastorage.items.storage.item.ItemStorageType;
import edivad.extrastorage.setup.Registration;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;

public class CarryOnIntegration {
    private static final String CARRYON_ID = "carryon";

    public static void registerCarryOn() {
        if (ModList.get().isLoaded(CARRYON_ID)) {
            for (CrafterTier crafterTier : CrafterTier.values()) {
                CarryOnIntegration.denyBlockCarryOn((Block)Registration.CRAFTER_BLOCK.get((Object)crafterTier).get());
            }
            for (Enum enum_ : ItemStorageType.values()) {
                CarryOnIntegration.denyBlockCarryOn((Block)Registration.ITEM_STORAGE_BLOCK.get(enum_).get());
            }
            for (Enum enum_ : FluidStorageType.values()) {
                CarryOnIntegration.denyBlockCarryOn((Block)Registration.FLUID_STORAGE_BLOCK.get(enum_).get());
            }
            CarryOnIntegration.denyBlockCarryOn((Block)Registration.ADVANCED_IMPORTER.get());
            CarryOnIntegration.denyBlockCarryOn((Block)Registration.ADVANCED_EXPORTER.get());
        }
    }

    private static void denyBlockCarryOn(Block block) {
        String registryName = block.getRegistryName().toString();
        InterModComms.sendTo((String)CARRYON_ID, (String)"blacklistBlock", () -> registryName);
        Main.logger.debug("Extra Storage made it impossible to use Carry On on this block -> " + registryName);
    }
}

