/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.datagen;

import edivad.extrastorage.items.storage.fluid.FluidStorageType;
import edivad.extrastorage.items.storage.item.ItemStorageType;
import edivad.extrastorage.setup.Registration;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;

public class TagGenerator {

    public static class ItemTags
    extends ItemTagsProvider {
        public ItemTags(DataGenerator generator, BlockTagsProvider provider, ExistingFileHelper existingFileHelper) {
            super(generator, provider, "extrastorage", existingFileHelper);
        }

        protected void m_6577_() {
            TagsProvider.TagAppender itemPartsBuilder = this.m_126548_(Items.ITEM_PARTS);
            TagsProvider.TagAppender itemDisksBuilder = this.m_126548_(Items.ITEM_DISKS);
            for (ItemStorageType type : ItemStorageType.values()) {
                Tag.Named<Item> tag = Items.PARTS_ITEM.get((Object)type);
                this.m_126548_(tag).m_126582_((Object)((Item)Registration.ITEM_STORAGE_PART.get((Object)type).get()));
                itemPartsBuilder.m_126580_(tag);
                tag = Items.DISKS_ITEM.get((Object)type);
                this.m_126548_(tag).m_126582_((Object)((Item)Registration.ITEM_DISK.get((Object)type).get()));
                itemDisksBuilder.m_126580_(tag);
            }
            TagsProvider.TagAppender fluidPartsBuilder = this.m_126548_(Items.FLUID_PARTS);
            TagsProvider.TagAppender fluidDisksBuilder = this.m_126548_(Items.FLUID_DISKS);
            for (FluidStorageType fluidStorageType : FluidStorageType.values()) {
                Tag.Named<Item> tag = Items.PARTS_FLUID.get((Object)fluidStorageType);
                this.m_126548_(tag).m_126582_((Object)((Item)Registration.FLUID_STORAGE_PART.get((Object)fluidStorageType).get()));
                fluidPartsBuilder.m_126580_(tag);
                tag = Items.DISKS_FLUID.get((Object)fluidStorageType);
                this.m_126548_(tag).m_126582_((Object)((Item)Registration.FLUID_DISK.get((Object)fluidStorageType).get()));
                fluidDisksBuilder.m_126580_(tag);
            }
            this.m_126548_(Items.PARTS).addTags(new Tag.Named[]{Items.ITEM_PARTS, Items.FLUID_PARTS});
            this.m_126548_(Items.DISKS).addTags(new Tag.Named[]{Items.ITEM_DISKS, Items.FLUID_DISKS});
            this.m_126533_(Blocks.ITEM_STORAGE_BLOCKS, Items.ITEM_STORAGE_BLOCKS);
            for (Enum enum_ : ItemStorageType.values()) {
                this.m_126533_(Blocks.STORAGE_BLOCKS_ITEM.get(enum_), Items.STORAGE_BLOCKS_ITEM.get(enum_));
            }
            this.m_126533_(Blocks.FLUID_STORAGE_BLOCKS, Items.FLUID_STORAGE_BLOCKS);
            for (Enum enum_ : FluidStorageType.values()) {
                this.m_126533_(Blocks.STORAGE_BLOCKS_FLUID.get(enum_), Items.STORAGE_BLOCKS_FLUID.get(enum_));
            }
            this.m_126533_(Blocks.STORAGE_BLOCKS, Items.STORAGE_BLOCKS);
        }
    }

    public static class BlockTags
    extends BlockTagsProvider {
        public BlockTags(DataGenerator generator, ExistingFileHelper existingFileHelper) {
            super(generator, "extrastorage", existingFileHelper);
        }

        protected void m_6577_() {
            TagsProvider.TagAppender itemBlocksBuilder = this.m_126548_(Blocks.ITEM_STORAGE_BLOCKS);
            for (ItemStorageType type : ItemStorageType.values()) {
                Tag.Named<Block> tag = Blocks.STORAGE_BLOCKS_ITEM.get((Object)type);
                this.m_126548_(tag).m_126582_((Object)((Block)Registration.ITEM_STORAGE_BLOCK.get((Object)type).get()));
                itemBlocksBuilder.m_126580_(tag);
            }
            TagsProvider.TagAppender fluidBlocksBuilder = this.m_126548_(Blocks.FLUID_STORAGE_BLOCKS);
            for (FluidStorageType type : FluidStorageType.values()) {
                Tag.Named<Block> tag = Blocks.STORAGE_BLOCKS_FLUID.get((Object)type);
                this.m_126548_(tag).m_126582_((Object)((Block)Registration.FLUID_STORAGE_BLOCK.get((Object)type).get()));
                fluidBlocksBuilder.m_126580_(tag);
            }
            this.m_126548_(Blocks.STORAGE_BLOCKS).addTags(new Tag.Named[]{Blocks.ITEM_STORAGE_BLOCKS, Blocks.FLUID_STORAGE_BLOCKS});
        }
    }

    public static class Items {
        public static final Tag.Named<Item> STORAGE_BLOCKS = Items.tag("storage_blocks");
        public static final Tag.Named<Item> ITEM_STORAGE_BLOCKS = Items.tag("storage_blocks/items");
        public static final Tag.Named<Item> FLUID_STORAGE_BLOCKS = Items.tag("storage_blocks/fluids");
        public static final Map<ItemStorageType, Tag.Named<Item>> STORAGE_BLOCKS_ITEM = new HashMap<ItemStorageType, Tag.Named<Item>>();
        public static final Map<FluidStorageType, Tag.Named<Item>> STORAGE_BLOCKS_FLUID = new HashMap<FluidStorageType, Tag.Named<Item>>();
        public static final Tag.Named<Item> PARTS = Items.tag("parts");
        public static final Tag.Named<Item> ITEM_PARTS = Items.tag("parts/items");
        public static final Tag.Named<Item> FLUID_PARTS = Items.tag("parts/fluids");
        public static final Map<ItemStorageType, Tag.Named<Item>> PARTS_ITEM = new HashMap<ItemStorageType, Tag.Named<Item>>();
        public static final Map<FluidStorageType, Tag.Named<Item>> PARTS_FLUID = new HashMap<FluidStorageType, Tag.Named<Item>>();
        public static final Tag.Named<Item> DISKS = Items.tag("disks");
        public static final Tag.Named<Item> ITEM_DISKS = Items.tag("disks/items");
        public static final Tag.Named<Item> FLUID_DISKS = Items.tag("disks/fluids");
        public static final Map<ItemStorageType, Tag.Named<Item>> DISKS_ITEM = new HashMap<ItemStorageType, Tag.Named<Item>>();
        public static final Map<FluidStorageType, Tag.Named<Item>> DISKS_FLUID = new HashMap<FluidStorageType, Tag.Named<Item>>();

        private static Tag.Named<Item> tag(String name) {
            return net.minecraft.tags.ItemTags.m_13194_((String)("refinedstorage:" + name));
        }

        static {
            for (ItemStorageType itemStorageType : ItemStorageType.values()) {
                STORAGE_BLOCKS_ITEM.put(itemStorageType, Items.tag("storage_blocks/items/" + itemStorageType.getName()));
                PARTS_ITEM.put(itemStorageType, Items.tag("parts/items/" + itemStorageType.getName()));
                DISKS_ITEM.put(itemStorageType, Items.tag("disks/items/" + itemStorageType.getName()));
            }
            for (Enum enum_ : FluidStorageType.values()) {
                STORAGE_BLOCKS_FLUID.put((FluidStorageType)enum_, Items.tag("storage_blocks/fluids/" + ((FluidStorageType)enum_).getName()));
                PARTS_FLUID.put((FluidStorageType)enum_, Items.tag("parts/fluids/" + ((FluidStorageType)enum_).getName()));
                DISKS_FLUID.put((FluidStorageType)enum_, Items.tag("disks/fluids/" + ((FluidStorageType)enum_).getName()));
            }
        }
    }

    public static class Blocks {
        public static final Tag.Named<Block> STORAGE_BLOCKS = Blocks.tag("storage_blocks");
        public static final Tag.Named<Block> ITEM_STORAGE_BLOCKS = Blocks.tag("storage_blocks/items");
        public static final Tag.Named<Block> FLUID_STORAGE_BLOCKS = Blocks.tag("storage_blocks/fluids");
        public static final Map<ItemStorageType, Tag.Named<Block>> STORAGE_BLOCKS_ITEM = new HashMap<ItemStorageType, Tag.Named<Block>>();
        public static final Map<FluidStorageType, Tag.Named<Block>> STORAGE_BLOCKS_FLUID = new HashMap<FluidStorageType, Tag.Named<Block>>();

        private static Tag.Named<Block> tag(String name) {
            return net.minecraft.tags.BlockTags.m_13116_((String)("refinedstorage:" + name));
        }

        static {
            for (ItemStorageType itemStorageType : ItemStorageType.values()) {
                STORAGE_BLOCKS_ITEM.put(itemStorageType, Blocks.tag("storage_blocks/items/" + itemStorageType.getName()));
            }
            for (Enum enum_ : FluidStorageType.values()) {
                STORAGE_BLOCKS_FLUID.put((FluidStorageType)enum_, Blocks.tag("storage_blocks/fluids/" + ((FluidStorageType)enum_).getName()));
            }
        }
    }
}

