/*
 * Decompiled with CFR 0.152.
 */
package jeresources.api.restrictions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jeresources.api.restrictions.Restriction;
import jeresources.api.util.BiomeHelper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class BiomeRestriction {
    public static final BiomeRestriction NO_RESTRICTION = new BiomeRestriction();
    public static final BiomeRestriction NONE = new BiomeRestriction(Biome.BiomeCategory.NONE, new Biome.BiomeCategory[0]);
    public static final BiomeRestriction TAIGA = new BiomeRestriction(Biome.BiomeCategory.TAIGA, new Biome.BiomeCategory[0]);
    public static final BiomeRestriction EXTREME_HILLS = new BiomeRestriction(Biome.BiomeCategory.EXTREME_HILLS, new Biome.BiomeCategory[0]);
    public static final BiomeRestriction JUNGLE = new BiomeRestriction(Biome.BiomeCategory.JUNGLE, new Biome.BiomeCategory[0]);
    public static final BiomeRestriction MESA = new BiomeRestriction(Biome.BiomeCategory.MESA, new Biome.BiomeCategory[0]);
    public static final BiomeRestriction PLAINS = new BiomeRestriction(Biome.BiomeCategory.PLAINS, new Biome.BiomeCategory[0]);
    public static final BiomeRestriction SAVANNA = new BiomeRestriction(Biome.BiomeCategory.SAVANNA, new Biome.BiomeCategory[0]);
    public static final BiomeRestriction ICY = new BiomeRestriction(Biome.BiomeCategory.ICY, new Biome.BiomeCategory[0]);
    public static final BiomeRestriction THEEND = new BiomeRestriction(Biome.BiomeCategory.THEEND, new Biome.BiomeCategory[0]);
    public static final BiomeRestriction BEACH = new BiomeRestriction(Biome.BiomeCategory.BEACH, new Biome.BiomeCategory[0]);
    public static final BiomeRestriction FOREST = new BiomeRestriction(Biome.BiomeCategory.FOREST, new Biome.BiomeCategory[0]);
    public static final BiomeRestriction OCEAN = new BiomeRestriction(Biome.BiomeCategory.OCEAN, new Biome.BiomeCategory[0]);
    public static final BiomeRestriction DESERT = new BiomeRestriction(Biome.BiomeCategory.DESERT, new Biome.BiomeCategory[0]);
    public static final BiomeRestriction RIVER = new BiomeRestriction(Biome.BiomeCategory.RIVER, new Biome.BiomeCategory[0]);
    public static final BiomeRestriction SWAMP = new BiomeRestriction(Biome.BiomeCategory.SWAMP, new Biome.BiomeCategory[0]);
    public static final BiomeRestriction MUSHROOM = new BiomeRestriction(Biome.BiomeCategory.MUSHROOM, new Biome.BiomeCategory[0]);
    public static final BiomeRestriction NETHER = new BiomeRestriction(Biome.BiomeCategory.NETHER, new Biome.BiomeCategory[0]);
    public static final BiomeRestriction DRIPSTONE_CAVES = new BiomeRestriction((ResourceKey<Biome>)Biomes.f_151784_);
    public static final BiomeRestriction BADLANDS = new BiomeRestriction((ResourceKey<Biome>)Biomes.f_48159_);
    private List<Biome> biomes = new ArrayList<Biome>();
    private Restriction.Type restrictionType;

    public BiomeRestriction() {
        this.restrictionType = Restriction.Type.NONE;
    }

    public BiomeRestriction(ResourceKey<Biome> biome) {
        this(BiomeHelper.getBiome(biome));
    }

    public BiomeRestriction(Biome biome) {
        this(Restriction.Type.WHITELIST, biome);
    }

    public BiomeRestriction(Restriction.Type restrictionType, Biome biome) {
        this(restrictionType, biome, new Biome[0]);
    }

    public BiomeRestriction(Biome biome, Biome ... moreBiomes) {
        this(Restriction.Type.WHITELIST, biome, moreBiomes);
    }

    public BiomeRestriction(Restriction.Type restrictionType, Biome biome, Biome ... moreBiomes) {
        this.restrictionType = restrictionType;
        switch (restrictionType) {
            case NONE: {
                break;
            }
            case WHITELIST: {
                this.biomes.add(biome);
                this.biomes.addAll(Arrays.asList(moreBiomes));
                break;
            }
            default: {
                this.biomes = BiomeHelper.getAllBiomes();
                this.biomes.remove(biome);
                this.biomes.removeAll(Arrays.asList(moreBiomes));
            }
        }
    }

    public BiomeRestriction(Biome.BiomeCategory biomeCategory, Biome.BiomeCategory ... biomeCategories) {
        this(Restriction.Type.WHITELIST, biomeCategory, biomeCategories);
    }

    public BiomeRestriction(Restriction.Type restrictionType, Biome.BiomeCategory biomeCategory, Biome.BiomeCategory ... biomeCategories) {
        this.restrictionType = restrictionType;
        switch (restrictionType) {
            case NONE: {
                break;
            }
            case WHITELIST: {
                this.biomes = this.getBiomes(biomeCategory, biomeCategories);
                break;
            }
            default: {
                this.biomes = BiomeHelper.getAllBiomes();
                this.biomes.removeAll(this.getBiomes(biomeCategory, biomeCategories));
            }
        }
    }

    private ArrayList<Biome> getBiomes(Biome.BiomeCategory biomeCategory, Biome.BiomeCategory ... biomeCategories) {
        ArrayList<Object> biomes = new ArrayList<Biome>();
        biomes.addAll(BiomeHelper.getBiomes(biomeCategory));
        for (int i = 1; i < biomeCategories.length; ++i) {
            ArrayList<Biome> newBiomes = new ArrayList<Biome>();
            for (Biome biome : BiomeHelper.getBiomes(biomeCategories[i])) {
                if (!biomes.remove(biome)) continue;
                newBiomes.add(biome);
            }
            biomes = newBiomes;
        }
        return biomes;
    }

    public List<String> toStringList() {
        return this.biomes.stream().filter(biome -> !biome.toString().equals("")).map(biome -> "  " + biome.toString()).collect(Collectors.toList());
    }

    public boolean equals(Object obj) {
        if (obj instanceof BiomeRestriction) {
            BiomeRestriction other = (BiomeRestriction)obj;
            return other.biomes.size() == this.biomes.size() && other.biomes.containsAll(this.biomes);
        }
        return false;
    }

    public boolean isMergeAble(BiomeRestriction other) {
        return other.restrictionType == Restriction.Type.NONE || this.restrictionType != Restriction.Type.NONE && !this.biomes.isEmpty() && other.biomes.containsAll(this.biomes);
    }

    public String toString() {
        return "Biomes: " + this.restrictionType + (String)(this.restrictionType != Restriction.Type.NONE ? " - " + this.biomes.size() : "");
    }

    public int hashCode() {
        return this.restrictionType.hashCode() ^ this.biomes.hashCode();
    }
}

