/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import jeresources.JEResources;
import jeresources.config.Settings;
import jeresources.jei.dungeon.DungeonCategory;
import jeresources.jei.dungeon.DungeonWrapper;
import jeresources.jei.enchantment.EnchantmentCategory;
import jeresources.jei.enchantment.EnchantmentMaker;
import jeresources.jei.mob.MobCategory;
import jeresources.jei.mob.MobWrapper;
import jeresources.jei.plant.PlantCategory;
import jeresources.jei.plant.PlantWrapper;
import jeresources.jei.villager.VillagerCategory;
import jeresources.jei.villager.VillagerWrapper;
import jeresources.jei.worldgen.WorldGenCategory;
import jeresources.jei.worldgen.WorldGenWrapper;
import jeresources.registry.DungeonRegistry;
import jeresources.registry.MobRegistry;
import jeresources.registry.PlantRegistry;
import jeresources.registry.VillagerRegistry;
import jeresources.registry.WorldGenRegistry;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIConfig
implements IModPlugin {
    public static final ResourceLocation MOB = new ResourceLocation("jeresources", "mob");
    public static final ResourceLocation DUNGEON = new ResourceLocation("jeresources", "dungeon");
    public static final ResourceLocation WORLD_GEN = new ResourceLocation("jeresources", "worldgen");
    public static final ResourceLocation PLANT = new ResourceLocation("jeresources", "plant");
    public static final ResourceLocation ENCHANTMENT = new ResourceLocation("jeresources", "enchantment");
    public static final ResourceLocation VILLAGER = new ResourceLocation("jeresources", "villager");
    public static final ResourceLocation[] CATEGORIES = new ResourceLocation[]{MOB, DUNGEON, WORLD_GEN, PLANT, ENCHANTMENT, VILLAGER};
    private static IJeiHelpers jeiHelpers;
    private static IJeiRuntime jeiRuntime;

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("jeresources");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(JEIConfig.asRecipes(WorldGenRegistry.getInstance().getWorldGen(), WorldGenWrapper::new), WORLD_GEN);
        registration.addRecipes(JEIConfig.asRecipes(PlantRegistry.getInstance().getAllPlants(), PlantWrapper::new), PLANT);
        registration.addRecipes(JEIConfig.asRecipes(MobRegistry.getInstance().getMobs(), MobWrapper::new), MOB);
        registration.addRecipes(JEIConfig.asRecipes(DungeonRegistry.getInstance().getDungeons(), DungeonWrapper::new), DUNGEON);
        registration.addRecipes(JEIConfig.asRecipes(VillagerRegistry.getInstance().getVillagers(), VillagerWrapper::new), VILLAGER);
        registration.addRecipes(EnchantmentMaker.createRecipes(registration.getIngredientManager().getAllIngredients(VanillaTypes.ITEM)), ENCHANTMENT);
    }

    public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
        JEIConfig.jeiRuntime = jeiRuntime;
        JEIConfig.hideCategories(Settings.hiddenCategories);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        jeiHelpers = registration.getJeiHelpers();
        registration.addRecipeCategories(new IRecipeCategory[]{new PlantCategory(), new WorldGenCategory(), new MobCategory(), new EnchantmentCategory(), new DungeonCategory(), new VillagerCategory()});
        JEResources.PROXY.initCompatibility();
    }

    public static void resetCategories() {
        if (jeiRuntime != null) {
            for (ResourceLocation category : CATEGORIES) {
                jeiRuntime.getRecipeManager().unhideRecipeCategory(category);
            }
        }
    }

    public static void hideCategories(String[] categories) {
        if (jeiRuntime != null) {
            for (String category : categories) {
                jeiRuntime.getRecipeManager().hideRecipeCategory(new ResourceLocation("jeresources", category));
            }
        }
    }

    public static IJeiHelpers getJeiHelpers() {
        return jeiHelpers;
    }

    private static <T, R> Collection<R> asRecipes(Collection<T> collection, Function<T, R> transformer) {
        return collection.stream().map(transformer).collect(Collectors.toList());
    }
}

