/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.adaptiveperformancetweakscore.commands.CustomCommand;
import de.markusbordihn.adaptiveperformancetweakscore.server.ServerLevelLoad;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerLevel;

public class LoadCommand
extends CustomCommand {
    private static final LoadCommand command = new LoadCommand();

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"load").requires(cs -> cs.m_6761_(2))).executes((Command)command);
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Map<ServerLevel, Double> serverLevelLoad = ServerLevelLoad.getLevelLoad();
        if (serverLevelLoad.isEmpty()) {
            LoadCommand.sendFeedback(context, "Unable to find any levels. Is Server / Level are already loaded?");
        } else {
            LoadCommand.sendFeedback(context, "Level Overview\n===");
            for (Map.Entry<ServerLevel, Double> worldEntry : serverLevelLoad.entrySet()) {
                ServerLevel serverLevel = worldEntry.getKey();
                String levelName = serverLevel.m_6018_().m_46472_().m_135782_().toString();
                Double avgTickTime = worldEntry.getValue();
                LoadCommand.sendFeedback(context, String.format("\u25cb %s %sms", levelName, avgTickTime));
            }
        }
        return 0;
    }
}

