/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class CommonConfig {
    private static final Logger log = LogManager.getLogger((String)"APTweaks(Core)");
    public static final ForgeConfigSpec commonSpec;
    public static final Config COMMON;

    private CommonConfig() {
    }

    static {
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Config)specPair.getLeft();
        log.info("{} common config ...", (Object)"Register Adaptive Performance Tweaks: Core");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
    }

    public static class Config {
        public final ForgeConfigSpec.IntValue timeBetweenUpdates;
        public final ForgeConfigSpec.BooleanValue logServerLoad;
        public final ForgeConfigSpec.BooleanValue logServerLevelLoad;
        public final ForgeConfigSpec.DoubleValue gameDifficultyFactorEasy;
        public final ForgeConfigSpec.DoubleValue gameDifficultyFactorNormal;
        public final ForgeConfigSpec.DoubleValue gameDifficultyFactorPeaceful;
        public final ForgeConfigSpec.DoubleValue gameDifficultyFactorHard;

        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Adaptive Performance Tweaks: Core");
            builder.push("General");
            this.timeBetweenUpdates = builder.comment("The time after a high to low load change is considered as valid. High loads are always considered immediately.").defineInRange("timeBetweenUpdates", 10, 1, 90);
            this.logServerLoad = builder.comment("Enable/Disable logging of the overall server load.").define("logServerLoad", true);
            this.logServerLevelLoad = builder.comment("Enable/Disable logging of the individual level load.").define("logServerLevelLoad", true);
            builder.pop();
            builder.push("Game Difficulty Factors");
            this.gameDifficultyFactorEasy = builder.defineInRange("gameDifficultyFactorEasy", 0.75, 0.1, 10.0);
            this.gameDifficultyFactorNormal = builder.defineInRange("gameDifficultyFactorNormal", 1.0, 0.1, 10.0);
            this.gameDifficultyFactorPeaceful = builder.defineInRange("gameDifficultyFactorPeaceful", 1.0, 0.1, 10.0);
            this.gameDifficultyFactorHard = builder.defineInRange("gameDifficultyFactorHard", 1.5, 0.1, 10.0);
            builder.pop();
        }
    }
}

