/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.debug;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class DebugManager {
    private static final Logger log = LogManager.getLogger((String)"APTweaks(Core)");

    protected DebugManager() {
    }

    public static void setLogLevel(Logger logger, String logLevel) {
        log.info("Try to change log level to {}", (Object)logLevel);
        Level newLogLevel = Level.INFO;
        switch (logLevel) {
            case "info": {
                break;
            }
            case "trace": {
                newLogLevel = Level.TRACE;
                break;
            }
            case "debug": {
                newLogLevel = Level.DEBUG;
                break;
            }
            case "warn": {
                newLogLevel = Level.WARN;
                break;
            }
            case "error": {
                newLogLevel = Level.ERROR;
                break;
            }
            case "fatal": {
                newLogLevel = Level.FATAL;
                break;
            }
            default: {
                log.error("Got invalid log level {} from config file for logger {}!", (Object)logLevel, (Object)logger);
            }
        }
        DebugManager.setLogLevel(logger, newLogLevel);
    }

    public static void setLogLevel(Logger logger, Level logLevel) {
        LoggerConfig loggerConfig;
        if (logLevel == null || logLevel == logger.getLevel()) {
            return;
        }
        String loggerName = logger.getName();
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        LoggerConfig specificConfig = loggerConfig = config.getLoggerConfig(loggerName);
        if (!loggerConfig.getName().equals(loggerName)) {
            log.info("Changing log level for {} from {} to {}", (Object)loggerName, (Object)logger.getLevel(), (Object)logLevel);
            specificConfig = new LoggerConfig(loggerName, logLevel, true);
            specificConfig.setParent(loggerConfig);
            config.addLogger(loggerName, specificConfig);
        }
        specificConfig.setLevel(logLevel);
        context.updateLoggers();
    }

    public static void enableDebugLevel(String loggerName, boolean enable) {
        Logger logger = LogManager.getLogger((String)loggerName);
        if (enable) {
            DebugManager.setLogLevel(logger, Level.DEBUG);
        } else {
            DebugManager.setLogLevel(logger, Level.INFO);
        }
    }
}

