/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.entity;

import com.mojang.math.Vector3d;
import de.markusbordihn.adaptiveperformancetweakscore.player.PlayerPosition;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class EntityManager {
    private static final Logger log = LogManager.getLogger((String)"APTweaks(Core)");
    private static short ticks = 0;
    private static final short VERIFICATION_TICK = 600;
    private static ConcurrentHashMap<String, Set<Entity>> entityMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Set<Entity>> entityMapPerWorld = new ConcurrentHashMap();

    protected EntityManager() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        entityMap = new ConcurrentHashMap();
        entityMapPerWorld = new ConcurrentHashMap();
    }

    @SubscribeEvent
    public static void handleClientServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            short s = ticks;
            ticks = (short)(s + 1);
            if (s >= 600) {
                EntityManager.verifyEntities();
                ticks = 0;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        Level level = event.getWorld();
        if (level.f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (!EntityManager.isRelevantEntity(entity)) {
            return;
        }
        String entityName = entity.m_20078_();
        String levelName = level.m_46472_().m_135782_().toString();
        if (entityName == null) {
            String entityType = entity.m_6095_().m_20675_();
            if (entityType.startsWith("entity.adhooks.")) {
                log.debug("Ignore {} entity {} in {}", (Object)"Advanced Hook Launchers", (Object)entity, (Object)levelName);
            } else if (entity.isMultipartEntity() || entityType.contains("body_part")) {
                log.debug("Ignore multipart entity {} in {}.", (Object)entity, (Object)levelName);
            } else if (entity.m_8077_()) {
                log.debug("Unknown entity name for entity {} ({}) with custom name {} in {}.", (Object)entity, (Object)entityType, (Object)entity.m_7770_().getString(), (Object)levelName);
            } else {
                log.warn("Unknown entity name for entity {} ({}) in {}. Please report this issue under {}!", (Object)entity, (Object)entityType, (Object)levelName, (Object)"https://github.com/MarkusBordihn/BOs-Adaptive-Performance-Tweaks/issues");
            }
            return;
        }
        if (entity.m_8077_()) {
            log.debug("Ignore custom entity {} with name {} in {}", (Object)entityName, (Object)entity.m_7770_().getString(), (Object)levelName);
            return;
        }
        EntityManager.addEntity(entity, entityName, levelName);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleEntityLeaveWorldEvent(EntityLeaveWorldEvent event) {
        Level level = event.getWorld();
        if (level.f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (!EntityManager.isRelevantEntity(entity)) {
            return;
        }
        String entityName = entity.m_20078_();
        if (entityName == null) {
            return;
        }
        String levelName = level.m_46472_().m_135782_().toString();
        EntityManager.removeEntity(entity, entityName, levelName);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleLivingDeathEvent(LivingDeathEvent event) {
        Entity entity = event.getEntity();
        Level level = entity.m_183503_();
        if (level.f_46443_) {
            return;
        }
        String entityName = entity.m_20078_();
        if (entityName == null) {
            return;
        }
        String levelName = level.m_46472_().m_135782_().toString();
        EntityManager.removeEntity(entity, entityName, levelName);
    }

    public static void addEntity(Entity entity, Level level) {
        String entityName = entity.m_20078_();
        String levelName = level.m_46472_().m_135782_().toString();
        EntityManager.addEntity(entity, entityName, levelName);
    }

    public static void addEntity(Entity entity, String entityName, String levelName) {
        Set entities = entityMap.computeIfAbsent("[" + levelName + "]" + entityName, key -> ConcurrentHashMap.newKeySet());
        entities.add(entity);
        Set entitiesPerWorld = entityMapPerWorld.computeIfAbsent(levelName, key -> ConcurrentHashMap.newKeySet());
        entitiesPerWorld.add(entity);
        log.debug("[Joined] Entity {} ({}) joined {}.", (Object)entityName, (Object)entity, (Object)levelName);
    }

    public static void removeEntity(Entity entity, Level level) {
        String entityName = entity.m_20078_();
        String levelName = level.m_46472_().m_135782_().toString();
        EntityManager.removeEntity(entity, entityName, levelName);
    }

    public static void removeEntity(Entity entity, String entityName, String levelName) {
        Set<Entity> entitiesPerWorld;
        Set<Entity> entities = entityMap.get("[" + levelName + "]" + entityName);
        if (entities != null) {
            entities.remove(entity);
        }
        if ((entitiesPerWorld = entityMapPerWorld.get(levelName)) != null) {
            entitiesPerWorld.remove(entity);
        }
        log.debug("[Left] Entity {} ({}) leaved {}.", (Object)entityName, (Object)entity, (Object)levelName);
    }

    public static Map<String, Set<Entity>> getEntities() {
        return entityMap;
    }

    public static Integer getNumberOfEntities(String levelName, String entityName) {
        Set<Entity> entities = entityMap.get("[" + levelName + "]" + entityName);
        if (entities == null) {
            return 0;
        }
        return entities.size();
    }

    public static Integer getNumberOfEntitiesPerWorld(String levelName) {
        Set<Entity> entities = entityMapPerWorld.get(levelName);
        if (entities == null) {
            return 0;
        }
        return entities.size();
    }

    public static Integer getNumberOfEntitiesInPlayerPositions(String levelName, String entityName, List<PlayerPosition> playerPositions) {
        if (!entityMap.contains("[" + levelName + "]" + entityName)) {
            return 0;
        }
        int counter = 0;
        HashSet entities = new HashSet(entityMap.get("[" + levelName + "]" + entityName));
        for (Entity entity : entities) {
            if (entity == null) continue;
            int x = (int)entity.m_20185_();
            int y = (int)entity.m_20186_();
            int z = (int)entity.m_20189_();
            for (PlayerPosition playerPosition : playerPositions) {
                if (!playerPosition.isInsidePlayerViewArea(levelName, x, y, z)) continue;
                ++counter;
            }
        }
        return counter;
    }

    public static Integer getNumberOfEntitiesInChunkPosition(String levelName, Vector3d position) {
        if (!entityMap.contains(levelName)) {
            return 0;
        }
        int counter = 0;
        int chunkX = (int)position.f_86214_ >> 4;
        int chunkZ = (int)position.f_86216_ >> 4;
        HashSet entities = new HashSet(entityMapPerWorld.get(levelName));
        for (Entity entity : entities) {
            if (entity == null) continue;
            int entityChunkX = (int)entity.m_20185_() >> 4;
            int entityChunkZ = (int)entity.m_20186_() >> 4;
            if (chunkX != entityChunkX || chunkZ != entityChunkZ) continue;
            ++counter;
        }
        return counter;
    }

    public static void verifyEntities() {
        Entity entity;
        Iterator<Entity> entityIterator;
        int removedEntries = 0;
        for (Set<Entity> entities : entityMap.values()) {
            entityIterator = entities.iterator();
            while (entityIterator.hasNext()) {
                entity = entityIterator.next();
                if (entity == null || !entity.m_146910_()) continue;
                entityIterator.remove();
                ++removedEntries;
            }
        }
        for (Set<Entity> entities : entityMapPerWorld.values()) {
            entityIterator = entities.iterator();
            while (entityIterator.hasNext()) {
                entity = entityIterator.next();
                if (entity == null || !entity.m_146910_()) continue;
                entityIterator.remove();
                ++removedEntries;
            }
        }
        if (removedEntries > 0) {
            log.debug("Removed {} entries during the verification", (Object)removedEntries);
        }
    }

    public static boolean isRelevantEntity(Entity entity) {
        return !(entity instanceof ExperienceOrb) && !(entity instanceof ItemEntity) && !(entity instanceof LightningBolt) && !(entity instanceof FallingBlockEntity) && !(entity instanceof Projectile) && !(entity instanceof MinecartChest) && !(entity instanceof AbstractMinecartContainer) && !(entity instanceof Player) && !(entity instanceof Npc) && !entity.m_146910_();
    }
}

