/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.player;

import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public class PlayerPosition {
    private static final String OVERWORLD = "minecraft:overworld";
    private static final int CHUNK_SIZE = 16;
    private static final int MAX_BUILD_HEIGHT = 320;
    private static final int MIN_BUILD_HEIGHT = -64;
    private static final int OVERGROUND_Y = 63;
    private static final int OVERGROUND_Y_MIN_VIEW = 51;
    private static final int WATER_Y_MAX_VIEW = 75;
    private ServerPlayer player;
    private String playerName = "";
    private UUID playerUUID;
    private String levelName = "";
    private boolean canSeeSky = false;
    private boolean isUnderWater = false;
    private boolean viewAreaCalculated = false;
    private long lastActionTime = 0L;
    private int posX = 0;
    private int posY = 0;
    private int posZ = 0;
    private int simulationDistance = 4;
    private int viewAreaDistance = 8;
    private int viewAreaStartX = 0;
    private int viewAreaStartY = 0;
    private int viewAreaStartZ = 0;
    private int viewAreaStopX = 0;
    private int viewAreaStopY = 0;
    private int viewAreaStopZ = 0;
    private int viewDistance = 8;

    public PlayerPosition(ServerPlayer player, int viewDistance, int simulationDistance) {
        this.player = player;
        this.playerName = player.m_7755_().getString();
        this.playerUUID = player.m_142081_();
        this.updatePosition(player.m_183503_().m_46472_().m_135782_().toString(), viewDistance, simulationDistance);
        this.calculateViewArea();
    }

    public void update(ServerPlayer player, int viewDistance, int simulationDistance) {
        this.update(player.m_183503_().m_46472_().m_135782_().toString(), viewDistance, simulationDistance);
    }

    public void update(String levelName, int viewDistance, int simulationDistance) {
        if (!this.levelName.equals(levelName) || this.viewDistance != viewDistance || this.simulationDistance != simulationDistance || this.lastActionTime != this.player.m_8956_() || this.hasChangedPosition()) {
            this.updatePosition(levelName, viewDistance, simulationDistance);
        }
    }

    public boolean isInsidePlayerViewArea(String levelName, int x, int y, int z) {
        if (!this.levelName.equals(levelName)) {
            return false;
        }
        this.calculateViewArea();
        return this.viewAreaStartX < x && x < this.viewAreaStopX && this.viewAreaStartY < y && y < this.viewAreaStopY && this.viewAreaStartZ < z && z < this.viewAreaStopZ;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public boolean hasChangedPosition() {
        Vec3 currentPosition = this.player.m_20182_();
        return Integer.compare(this.posX, (int)currentPosition.f_82479_) != 0 || Integer.compare(this.posY, (int)currentPosition.f_82480_) != 0 || Integer.compare(this.posZ, (int)currentPosition.f_82481_) != 0;
    }

    private void updatePosition(String levelName, int viewDistance, int simulationDistance) {
        this.lastActionTime = this.player.m_8956_();
        Vec3 position = this.player.m_20182_();
        this.posX = (int)position.f_82479_;
        this.posY = (int)position.f_82480_;
        this.posZ = (int)position.f_82481_;
        this.canSeeSky = this.player.m_183503_().m_45527_(this.player.m_142538_());
        this.isUnderWater = this.player.m_5842_();
        if (!this.levelName.equals(levelName)) {
            this.levelName = levelName;
        }
        this.simulationDistance = simulationDistance;
        this.viewDistance = viewDistance;
        this.viewAreaCalculated = false;
    }

    private void calculateViewArea() {
        if (this.viewAreaCalculated) {
            return;
        }
        this.viewAreaDistance = !this.canSeeSky || this.isUnderWater ? (this.simulationDistance < this.viewDistance ? this.simulationDistance : this.simulationDistance - 1) * 16 : this.viewDistance * 16;
        this.viewAreaStartX = this.posX - this.viewAreaDistance;
        this.viewAreaStopX = this.posX + this.viewAreaDistance;
        this.viewAreaStartY = Math.max(this.posY - this.viewAreaDistance, -64);
        this.viewAreaStopY = Math.min(this.posY + this.viewAreaDistance, 320);
        this.viewAreaStartZ = this.posZ - this.viewAreaDistance;
        this.viewAreaStopZ = this.posZ + this.viewAreaDistance;
        if (OVERWORLD.equals(this.levelName)) {
            if (this.posY >= 63) {
                this.viewAreaStartY = 51;
            } else if (!this.canSeeSky) {
                this.viewAreaStopY = 63;
            } else if (this.isUnderWater) {
                this.viewAreaStopY = 75;
            }
        }
        this.viewAreaCalculated = true;
    }

    public String toString() {
        this.calculateViewArea();
        return "PlayerPosition[Player{name: '" + this.playerName + "', uuid: '" + this.playerUUID + "', world: '" + this.levelName + "', x:" + this.posX + ", y:" + this.posY + ", z:" + this.posZ + ", viewDistance: " + this.viewDistance + ", simulationDistance: " + this.simulationDistance + ", viewAreaDistance: " + this.viewAreaDistance + "}, Range{x:" + this.viewAreaStartX + " to " + this.viewAreaStopX + ", y:" + this.viewAreaStartY + " to " + this.viewAreaStopY + ", z:" + this.viewAreaStartZ + " to " + this.viewAreaStopZ + "}, Meta{canSeeSky: " + this.canSeeSky + ", isUnderWater: " + this.isUnderWater + "}]";
    }
}

