/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.player;

import de.markusbordihn.adaptiveperformancetweakscore.player.PlayerPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class PlayerPositionManager {
    private static final Logger log = LogManager.getLogger((String)"APTweaks(Core)");
    private static Map<String, PlayerPosition> playerPositionMap = new ConcurrentHashMap<String, PlayerPosition>();
    private static int ticks = 0;

    protected PlayerPositionManager() {
    }

    @SubscribeEvent
    public static void onServerAboutToStartEvent(ServerAboutToStartEvent event) {
        playerPositionMap = new ConcurrentHashMap<String, PlayerPosition>();
    }

    @SubscribeEvent
    public static void handlePlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        String playerUUID = event.getPlayer().m_20149_();
        if (playerUUID != null) {
            log.debug("Removing player {} from position tracking.", (Object)event.getPlayer());
            playerPositionMap.remove(playerUUID);
        }
    }

    @SubscribeEvent
    public static void handleServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++ticks;
            return;
        }
        if (ticks >= 50) {
            PlayerList playerList;
            MinecraftServer minecraftServer = ServerLifecycleHooks.getCurrentServer();
            if (minecraftServer != null && (playerList = minecraftServer.m_6846_()) != null) {
                List serverPlayerList = playerList.m_11314_();
                int viewDistance = playerList.m_11312_();
                int simulationDistance = playerList.m_184213_();
                for (ServerPlayer player : serverPlayerList) {
                    if (!player.m_6084_() || player.m_9232_()) continue;
                    PlayerPositionManager.updatePlayerPosition(player, viewDistance, simulationDistance);
                }
            }
            ticks = 0;
        }
    }

    public static List<PlayerPosition> getPlayerPositionsInsideViewArea(String world, int x, int y, int z) {
        ArrayList<PlayerPosition> playerPositions = new ArrayList<PlayerPosition>();
        for (PlayerPosition playerPosition : playerPositionMap.values()) {
            if (!playerPosition.isInsidePlayerViewArea(world, x, y, z)) continue;
            playerPositions.add(playerPosition);
        }
        return playerPositions;
    }

    public static boolean isInsidePlayersViewArea(String world, int x, int y, int z) {
        for (PlayerPosition playerPosition : playerPositionMap.values()) {
            if (!playerPosition.isInsidePlayerViewArea(world, x, y, z)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, PlayerPosition> getPlayerPositionMap() {
        return playerPositionMap;
    }

    private static void updatePlayerPosition(ServerPlayer player, int viewDistance, int simulationDistance) {
        PlayerPosition playerPosition = playerPositionMap.computeIfAbsent(player.m_20149_(), key -> new PlayerPosition(player, viewDistance, simulationDistance));
        playerPosition.update(player, viewDistance, simulationDistance);
    }
}

