/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.server;

import de.markusbordihn.adaptiveperformancetweakscore.config.CommonConfig;
import de.markusbordihn.adaptiveperformancetweakscore.server.ServerLevelLoadEvent;
import de.markusbordihn.adaptiveperformancetweakscore.server.ServerManager;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class ServerLevelLoad {
    private static final Logger log = LogManager.getLogger((String)"APTweaks(Core)");
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static boolean logServerLevelLoad = (Boolean)ServerLevelLoad.COMMON.logServerLevelLoad.get();
    private static int timeBetweenUpdates = (Integer)ServerLevelLoad.COMMON.timeBetweenUpdates.get() * 1000;
    private static long lastUpdateTime = System.currentTimeMillis();
    private static Map<ServerLevel, Double> levelLoad = new ConcurrentHashMap<ServerLevel, Double>();
    private static Map<ServerLevel, ServerLevelLoadLevel> levelLoadLevel = new ConcurrentHashMap<ServerLevel, ServerLevelLoadLevel>();

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        levelLoad = new ConcurrentHashMap<ServerLevel, Double>();
        levelLoadLevel = new ConcurrentHashMap<ServerLevel, ServerLevelLoadLevel>();
        logServerLevelLoad = (Boolean)ServerLevelLoad.COMMON.logServerLevelLoad.get();
        timeBetweenUpdates = (Integer)ServerLevelLoad.COMMON.timeBetweenUpdates.get() * 1000;
    }

    public static void measureLoadAndPost(Dist dist) {
        for (ServerLevel ServerLevel2 : ServerManager.getAllLevels()) {
            long[] tickTimes = ServerManager.getMinecraftServer().getTickTime(ServerLevel2.m_46472_());
            if (tickTimes == null) continue;
            double avgTickTime = Arrays.stream(tickTimes).average().orElse(Double.NaN) / 1000000.0;
            double lastAvgTickTime = levelLoad.getOrDefault(ServerLevel2, 45.0);
            if (lastAvgTickTime >= avgTickTime && System.currentTimeMillis() - lastUpdateTime < (long)timeBetweenUpdates) continue;
            levelLoad.put(ServerLevel2, avgTickTime);
            ServerLevelLoadLevel lastLoadLevel = levelLoadLevel.getOrDefault(ServerLevel2, ServerLevelLoadLevel.NORMAL);
            ServerLevelLoadLevel loadLevel = ServerLevelLoad.getServerLevelLoadLevelFromTickTime(avgTickTime);
            levelLoadLevel.put(ServerLevel2, loadLevel);
            if (loadLevel != lastLoadLevel && logServerLevelLoad) {
                String loadIndicator = lastAvgTickTime > avgTickTime ? "\u00e2\u2020\u201c" : "\u00e2\u2020\u2018";
                log.info("{} {} Level load for {} changed from {} (avg. {}) to {} (avg. {})", (Object)"[APTweaks:Core]", (Object)loadIndicator, (Object)ServerLevel2.m_46472_().m_135782_(), (Object)lastLoadLevel, (Object)lastAvgTickTime, (Object)loadLevel, (Object)avgTickTime);
            }
            MinecraftForge.EVENT_BUS.post((Event)new ServerLevelLoadEvent(ServerLevel2, loadLevel, lastLoadLevel, avgTickTime, lastAvgTickTime, dist));
        }
        lastUpdateTime = System.currentTimeMillis();
    }

    public static ServerLevelLoadLevel getServerLevelLoadLevelFromTickTime(double tickTime) {
        if (tickTime <= 15.0) {
            return ServerLevelLoadLevel.VERY_LOW;
        }
        if (tickTime <= 35.0) {
            return ServerLevelLoadLevel.LOW;
        }
        if (tickTime <= 41.0) {
            return ServerLevelLoadLevel.NORMAL;
        }
        if (tickTime <= 46.0) {
            return ServerLevelLoadLevel.MEDIUM;
        }
        if (tickTime <= 50.0) {
            return ServerLevelLoadLevel.HIGH;
        }
        if (tickTime > 50.0) {
            return ServerLevelLoadLevel.VERY_HIGH;
        }
        return ServerLevelLoadLevel.NORMAL;
    }

    public static Map<ServerLevel, Double> getLevelLoad() {
        return levelLoad;
    }

    public static Map<ServerLevel, ServerLevelLoadLevel> getLevelLoadLevel() {
        return levelLoadLevel;
    }

    public static enum ServerLevelLoadLevel {
        VERY_LOW,
        LOW,
        NORMAL,
        MEDIUM,
        HIGH,
        VERY_HIGH;

    }
}

