/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.server;

import de.markusbordihn.adaptiveperformancetweakscore.server.ServerLoad;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.Event;

public class ServerLoadEvent
extends Event {
    private Dist dist;
    private ServerLoad.ServerLoadLevel lastServerLoadLevel = ServerLoad.ServerLoadLevel.NORMAL;
    private ServerLoad.ServerLoadLevel serverLoadLevel = ServerLoad.ServerLoadLevel.NORMAL;
    private double avgTickTime = 50.0;
    private double lastAvgTickTime = 45.0;

    public ServerLoadEvent(ServerLoad.ServerLoadLevel currentServerLoad, ServerLoad.ServerLoadLevel lastServerLoad, double avgTickTime, double lastAvgTickTim, Dist dist) {
        this.avgTickTime = avgTickTime;
        this.dist = dist;
        this.lastAvgTickTime = lastAvgTickTim;
        this.lastServerLoadLevel = lastServerLoad;
        this.serverLoadLevel = currentServerLoad;
    }

    public boolean isDedicatedServer() {
        return this.dist.isDedicatedServer();
    }

    public boolean isClient() {
        return this.dist.isClient();
    }

    public double getAvgTickTime() {
        return this.avgTickTime;
    }

    public double getLastAvgTickTime() {
        return this.lastAvgTickTime;
    }

    public ServerLoad.ServerLoadLevel getServerLoad() {
        return this.serverLoadLevel;
    }

    public ServerLoad.ServerLoadLevel getLastServerLoad() {
        return this.lastServerLoadLevel;
    }

    public boolean hasVeryHighServerLoad() {
        return this.serverLoadLevel == ServerLoad.ServerLoadLevel.VERY_HIGH;
    }

    public boolean hasHighServerLoad() {
        return this.serverLoadLevel == ServerLoad.ServerLoadLevel.MEDIUM || this.serverLoadLevel == ServerLoad.ServerLoadLevel.HIGH || this.serverLoadLevel == ServerLoad.ServerLoadLevel.VERY_HIGH;
    }

    public boolean hasNormalServerLoad() {
        return this.serverLoadLevel == ServerLoad.ServerLoadLevel.NORMAL;
    }

    public boolean hasLowServerLoad() {
        return this.serverLoadLevel == ServerLoad.ServerLoadLevel.VERY_LOW || this.serverLoadLevel == ServerLoad.ServerLoadLevel.LOW;
    }

    public boolean hasChanged() {
        return this.serverLoadLevel == this.lastServerLoadLevel;
    }
}

