/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.server;

import de.markusbordihn.adaptiveperformancetweakscore.config.CommonConfig;
import de.markusbordihn.adaptiveperformancetweakscore.server.OptimizationEvent;
import de.markusbordihn.adaptiveperformancetweakscore.server.ServerLevelLoad;
import de.markusbordihn.adaptiveperformancetweakscore.server.ServerLoad;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.DifficultyChangeEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class ServerManager {
    private static final Logger log = LogManager.getLogger((String)"APTweaks(Core)");
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static double gameDifficultyFactorEasy = (Double)ServerManager.COMMON.gameDifficultyFactorEasy.get();
    private static double gameDifficultyFactorNormal = (Double)ServerManager.COMMON.gameDifficultyFactorNormal.get();
    private static double gameDifficultyFactorPeaceful = (Double)ServerManager.COMMON.gameDifficultyFactorPeaceful.get();
    private static double gameDifficultyFactorHard = (Double)ServerManager.COMMON.gameDifficultyFactorHard.get();
    private static short ticks = 0;
    private static final short SERVER_LOAD_TICK = 20;
    private static final short WORLD_LOAD_TICK = 40;
    private static final short OPTIMIZATION_TICK = 60;
    private static final short RESET_TICK = 120;
    private static MinecraftServer minecraftServer = null;
    private static Iterable<ServerLevel> serverLevels = null;
    private static Difficulty gameDifficulty = Difficulty.NORMAL;
    private static double gameDifficultyFactor = gameDifficultyFactorNormal;

    protected ServerManager() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        gameDifficultyFactorEasy = (Double)ServerManager.COMMON.gameDifficultyFactorEasy.get();
        gameDifficultyFactorNormal = (Double)ServerManager.COMMON.gameDifficultyFactorNormal.get();
        gameDifficultyFactorPeaceful = (Double)ServerManager.COMMON.gameDifficultyFactorPeaceful.get();
        gameDifficultyFactorHard = (Double)ServerManager.COMMON.gameDifficultyFactorHard.get();
        log.info("{} Game difficult factors EASY: {}, NORMAL: {}, PEACEFUL: {} and HARD: {}", (Object)"[APTweaks:Core]", (Object)gameDifficultyFactorEasy, (Object)gameDifficultyFactorNormal, (Object)gameDifficultyFactorPeaceful, (Object)gameDifficultyFactorHard);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void handleClientServerStartingEvent(ServerStartingEvent event) {
        ServerManager.updateGameDifficulty(ServerManager.getMinecraftServer().m_129910_().m_5472_());
        log.info("{} Max number of local players is set to {}", (Object)"[APTweaks:Core]", (Object)ServerManager.getMinecraftServer().m_6846_().m_11310_());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public static void handleDedicatedServerStartingEvent(ServerStartingEvent event) {
        ServerManager.updateGameDifficulty(ServerManager.getMinecraftServer().m_129910_().m_5472_());
        log.info("{} Max number of remote players is set to {}", (Object)"[APTweaks:Core]", (Object)ServerManager.getMinecraftServer().m_6846_().m_11310_());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void handleClientServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ServerManager.handleServerTickEvent(Dist.CLIENT);
        } else {
            ticks = (short)(ticks + 1);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public static void handleDedicatedServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ServerManager.handleServerTickEvent(Dist.DEDICATED_SERVER);
        } else {
            ticks = (short)(ticks + 1);
        }
    }

    @SubscribeEvent
    public static void handleDifficultyChangeEvent(DifficultyChangeEvent event) {
        ServerManager.updateGameDifficulty(event.getDifficulty());
    }

    public static void handleServerTickEvent(Dist dist) {
        if (ticks == 20) {
            ServerLoad.measureLoadAndPost(dist);
        } else if (ticks == 40) {
            ServerLevelLoad.measureLoadAndPost(dist);
        } else if (ticks == 60) {
            MinecraftForge.EVENT_BUS.post((Event)new OptimizationEvent(dist));
        } else if (ticks >= 120) {
            ticks = 0;
        }
    }

    public static MinecraftServer getMinecraftServer() {
        if (minecraftServer == null) {
            minecraftServer = ServerLifecycleHooks.getCurrentServer();
        }
        return minecraftServer;
    }

    public static float getAverageTickTime() {
        return minecraftServer != null ? minecraftServer.m_129903_() : 50.0f;
    }

    public static Iterable<ServerLevel> getAllLevels() {
        if (serverLevels == null) {
            serverLevels = ServerManager.getMinecraftServer().m_129785_();
        }
        return serverLevels;
    }

    public static Difficulty getGameDifficulty() {
        return gameDifficulty;
    }

    public static double getGameDifficultyFactor() {
        return gameDifficultyFactor;
    }

    private static void updateGameDifficulty(Difficulty difficulty) {
        if (difficulty == gameDifficulty) {
            return;
        }
        gameDifficulty = difficulty;
        switch (difficulty) {
            case EASY: {
                gameDifficultyFactor = gameDifficultyFactorEasy;
                break;
            }
            case NORMAL: {
                gameDifficultyFactor = gameDifficultyFactorNormal;
                break;
            }
            case PEACEFUL: {
                gameDifficultyFactor = gameDifficultyFactorPeaceful;
                break;
            }
            case HARD: {
                gameDifficultyFactor = gameDifficultyFactorHard;
                break;
            }
            default: {
                gameDifficultyFactor = gameDifficultyFactorNormal;
            }
        }
        log.info("{} Game difficulty is set to {} with a {} factor.", (Object)"[APTweaks:Core]", (Object)gameDifficulty, (Object)gameDifficultyFactor);
    }
}

