/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod;

import com.tom.storagemod.StorageMod;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static boolean onlyTrims;
    public static int invRange;
    public static int invConnectorMax;
    public static int wirelessRange;
    public static Set<Block> multiblockInvs;
    public static int advWirelessRange;
    static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    private static void load() {
        onlyTrims = (Boolean)Config.SERVER.onlyTrimsConnect.get();
        invRange = (Integer)Config.SERVER.inventoryConnectorRange.get() * (Integer)Config.SERVER.inventoryConnectorRange.get();
        invConnectorMax = (Integer)Config.SERVER.inventoryCableConnectorMaxCables.get();
        wirelessRange = (Integer)Config.SERVER.wirelessRange.get();
        multiblockInvs = ((List)Config.SERVER.multiblockInvs.get()).stream().map(ResourceLocation::new).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getValue(arg_0)).filter(e -> e != null && e != Blocks.f_50016_).collect(Collectors.toSet());
        advWirelessRange = (Integer)Config.SERVER.advWirelessRange.get();
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        StorageMod.LOGGER.info("Loaded Tom's Simple Storage config file {}", (Object)configEvent.getConfig().getFileName());
        Config.load();
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        StorageMod.LOGGER.info("Tom's Simple Storage config just got changed on the file system!");
        Config.load();
    }

    static {
        invConnectorMax = 0;
        multiblockInvs = new HashSet<Block>();
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public ForgeConfigSpec.IntValue inventoryConnectorRange;
        public ForgeConfigSpec.IntValue inventoryCableConnectorMaxCables;
        public ForgeConfigSpec.IntValue wirelessRange;
        public ForgeConfigSpec.BooleanValue onlyTrimsConnect;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> multiblockInvs;
        public ForgeConfigSpec.IntValue advWirelessRange;

        private Server(ForgeConfigSpec.Builder builder) {
            this.inventoryConnectorRange = builder.comment("Inventory Connector Range").translation("tomsstorage.config.inventory_connector_range").defineInRange("inventoryConnectorRange", 16, 4, 256);
            this.onlyTrimsConnect = builder.comment("Only Allow Trims to Connect Inventories").translation("tomsstorage.config.only_trims_connect").define("onlyTrimsConnect", false);
            this.inventoryCableConnectorMaxCables = builder.comment("Inventory Cable Connector Maximum number of cables").translation("tomsstorage.config.inv_cable_connector_max_scan").defineInRange("invCableConnectorMaxScanSize", 2048, 16, Integer.MAX_VALUE);
            this.wirelessRange = builder.comment("Wireless terminal reach").translation("tomsstorage.config.wireless_reach").defineInRange("wirelessReach", 16, 4, 64);
            this.multiblockInvs = builder.comment("Multiblock inventories").translation("tomsstorage.config.multiblock_inv").defineList("multiblockInv", Collections.emptyList(), s -> true);
            this.advWirelessRange = builder.comment("Wireless terminal reach").translation("tomsstorage.config.adv_wireless_range").defineInRange("advWirelessRange", 64, 16, 512);
        }
    }
}

